/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.util.Comparator;
import java.util.UUID;

public final class UUIDTools {
    private static final TimeBasedGenerator generator = Generators.timeBasedGenerator();
    private static Comparator<UUID> timeBasedComparator = null;

    private UUIDTools() {
    }

    public static byte[] toByteArray(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (15 - i));
        }
        return buffer;
    }

    public static UUID toUUID(byte[] uuid) {
        int i;
        if (uuid == null || uuid.length != 16) {
            throw new IllegalArgumentException("UUID byte array must contain exactly 16 bytes");
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(uuid[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(uuid[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static UUID createTimeBasedUUID() {
        return generator.generate();
    }

    public static UUID createRandomUUID() {
        return UUID.randomUUID();
    }

    public static UUID fromString(String uuid) {
        return UUID.fromString(uuid);
    }

    public static long toUnixTimestamp(UUID uuid) {
        return (uuid.timestamp() - 122192928000000000L) / 10000L;
    }

    public static Comparator<UUID> getTimeBasedComparator() {
        if (timeBasedComparator == null) {
            timeBasedComparator = (o1, o2) -> {
                long time2;
                long time1 = o1.timestamp();
                if (time1 == (time2 = o2.timestamp())) {
                    return 0;
                }
                boolean smaller = time1 < time2 ^ time1 < 0L ^ time2 < 0L;
                return smaller ? -1 : 1;
            };
        }
        return timeBasedComparator;
    }
}

