/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging.internal;

import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.messaging.internal.MessageQueueBoundPayload;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.SystemSerializationFramework;

@Message(immutable=true, durable=false, serializationFramework=SystemSerializationFramework.class)
public final class ActorNodeMessage
implements MessageQueueBoundPayload {
    private final String nodeId;
    private final ActorRef receiverRef;
    private final Object message;
    private final boolean undeliverable;

    public ActorNodeMessage(String nodeId, ActorRef receiverRef, Object message) {
        this(nodeId, receiverRef, message, false);
    }

    public ActorNodeMessage(String nodeId, ActorRef receiverRef, Object message, boolean undeliverable) {
        this.nodeId = nodeId;
        this.receiverRef = receiverRef;
        this.message = message;
        this.undeliverable = undeliverable;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public ActorRef getReceiverRef() {
        return this.receiverRef;
    }

    public Object getMessage() {
        return this.message;
    }

    public boolean isUndeliverable() {
        return this.undeliverable;
    }

    @Override
    @Nullable
    public String getMessageQueueAffinityKey() {
        return this.receiverRef != null ? this.receiverRef.getActorId() : null;
    }
}

