/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization;

import com.google.common.collect.ImmutableMap;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.messaging.internal.ActivateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.ActorNodeMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CancelScheduledMessageMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CreateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.DestroyActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.PersistActorMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.CancelMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.CompletedMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.NextMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.RequestMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.SubscribeMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.SubscriptionMessage;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.SystemDeserializers;
import org.elasticsoftware.elasticactors.serialization.internal.ActivateActorMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorNodeMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.CancelScheduledMessageMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.CreateActorMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.DestroyActorMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistActorMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.CancelMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.CompletedMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.NextMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.RequestMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.SubscribeMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.SubscriptionMessageDeserializer;

public final class MessagingSystemDeserializers
implements SystemDeserializers {
    private final ImmutableMap<Class, MessageDeserializer> systemDeserializers;

    public MessagingSystemDeserializers(InternalActorSystems cluster, ActorRefFactory actorRefFactory) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ActorRefDeserializer actorRefDeserializer = new ActorRefDeserializer(actorRefFactory);
        builder.put(CreateActorMessage.class, (Object)new CreateActorMessageDeserializer((SerializationFrameworks)cluster));
        builder.put(DestroyActorMessage.class, (Object)new DestroyActorMessageDeserializer(actorRefDeserializer));
        builder.put(ActivateActorMessage.class, (Object)new ActivateActorMessageDeserializer());
        builder.put(CancelScheduledMessageMessage.class, (Object)new CancelScheduledMessageMessageDeserializer());
        builder.put(ActorNodeMessage.class, (Object)new ActorNodeMessageDeserializer(actorRefDeserializer, cluster));
        builder.put(PersistActorMessage.class, (Object)new PersistActorMessageDeserializer(actorRefDeserializer));
        builder.put(CancelMessage.class, (Object)new CancelMessageDeserializer(actorRefDeserializer));
        builder.put(CompletedMessage.class, (Object)new CompletedMessageDeserializer());
        builder.put(SubscribeMessage.class, (Object)new SubscribeMessageDeserializer(actorRefDeserializer));
        builder.put(RequestMessage.class, (Object)new RequestMessageDeserializer());
        builder.put(SubscriptionMessage.class, (Object)new SubscriptionMessageDeserializer());
        builder.put(NextMessage.class, (Object)new NextMessageDeserializer());
        this.systemDeserializers = builder.build();
    }

    @Override
    public <T> MessageDeserializer<T> get(Class<T> messageClass) {
        return (MessageDeserializer)this.systemDeserializers.get(messageClass);
    }
}

