/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization;

import com.google.common.collect.ImmutableMap;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.messaging.internal.ActivateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.ActorNodeMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CancelScheduledMessageMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CreateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.DestroyActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.PersistActorMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.CancelMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.CompletedMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.NextMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.RequestMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.SubscribeMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.SubscriptionMessage;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.SystemSerializers;
import org.elasticsoftware.elasticactors.serialization.internal.ActivateActorMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorNodeMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.CancelScheduleMessageMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.CreateActorMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.DestroyActorMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistActorMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.CancelMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.CompletedMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.NextMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.RequestMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.SubscribeMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.reactivestreams.SubscriptionMessageSerializer;

public final class MessagingSystemSerializers
implements SystemSerializers {
    private final ImmutableMap<Class, MessageSerializer> systemSerializers;

    public MessagingSystemSerializers(InternalActorSystems cluster) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(CreateActorMessage.class, (Object)new CreateActorMessageSerializer((SerializationFrameworks)cluster));
        builder.put(DestroyActorMessage.class, (Object)new DestroyActorMessageSerializer());
        builder.put(ActivateActorMessage.class, (Object)new ActivateActorMessageSerializer());
        builder.put(CancelScheduledMessageMessage.class, (Object)new CancelScheduleMessageMessageSerializer());
        builder.put(ActorNodeMessage.class, (Object)new ActorNodeMessageSerializer(cluster));
        builder.put(PersistActorMessage.class, (Object)new PersistActorMessageSerializer());
        builder.put(CancelMessage.class, (Object)new CancelMessageSerializer());
        builder.put(CompletedMessage.class, (Object)new CompletedMessageSerializer());
        builder.put(NextMessage.class, (Object)new NextMessageSerializer());
        builder.put(RequestMessage.class, (Object)new RequestMessageSerializer());
        builder.put(SubscribeMessage.class, (Object)new SubscribeMessageSerializer());
        builder.put(SubscriptionMessage.class, (Object)new SubscriptionMessageSerializer());
        this.systemSerializers = builder.build();
    }

    @Override
    public <T> MessageSerializer<T> get(Class<T> messageClass) {
        return (MessageSerializer)this.systemSerializers.get(messageClass);
    }
}

