/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;

public final class SerializationContext {
    private static final ThreadLocal<IdentityHashMap<Object, ByteBuffer>> serializationCache = new ThreadLocal();
    private static final ThreadLocal<EvictingMap<DeserializationKey, Object>> deserializationCache = new ThreadLocal();
    private static final ThreadLocal<DeserializationKey> keyPool = ThreadLocal.withInitial(() -> new DeserializationKey(null, null));
    private static final boolean deserializationCacheEnabled = Boolean.parseBoolean(System.getProperty("ea.deserializationCache.enabled", "false"));
    private static final boolean serializationCacheEnabled = Boolean.parseBoolean(System.getProperty("ea.serializationCache.enabled", "false"));

    private SerializationContext() {
    }

    public static void initialize() {
        if (serializationCacheEnabled && serializationCache.get() == null) {
            serializationCache.set(new IdentityHashMap());
        }
        if (deserializationCacheEnabled && deserializationCache.get() == null) {
            deserializationCache.set(new EvictingMap());
        }
    }

    public static void reset() {
        if (serializationCache.get() != null) {
            serializationCache.get().clear();
        }
    }

    public static <T> T deserialize(MessageDeserializer<T> deserializer, ByteBuffer bytes) throws IOException {
        Object message;
        EvictingMap<DeserializationKey, Object> deserializationCache;
        EvictingMap<DeserializationKey, Object> evictingMap = deserializationCache = deserializationCacheEnabled ? SerializationContext.deserializationCache.get() : null;
        if (deserializationCache != null && (message = deserializationCache.get(keyPool.get().populate(deserializer.getMessageClass(), bytes))) != null) {
            return (T)message;
        }
        bytes.mark();
        message = deserializer.deserialize(bytes);
        Message immutableAnnotation = message.getClass().getAnnotation(Message.class);
        if (immutableAnnotation != null && immutableAnnotation.immutable() && serializationCache.get() != null) {
            bytes.reset();
            serializationCache.get().put(message, bytes.asReadOnlyBuffer());
            if (deserializationCache != null) {
                deserializationCache.put(new DeserializationKey(deserializer.getMessageClass(), bytes.asReadOnlyBuffer()), message);
            }
        }
        return (T)message;
    }

    public static ByteBuffer serialize(MessageSerializer serializer, Object message) throws IOException {
        Message immutableAnnotation = message.getClass().getAnnotation(Message.class);
        if (immutableAnnotation != null && immutableAnnotation.immutable() && serializationCache.get() != null) {
            EvictingMap<DeserializationKey, Object> deserializationCache = deserializationCacheEnabled ? SerializationContext.deserializationCache.get() : null;
            ByteBuffer cachedBuffer = serializationCache.get().get(message);
            if (cachedBuffer != null) {
                return cachedBuffer.asReadOnlyBuffer();
            }
            ByteBuffer serializedBuffer = serializer.serialize(message);
            serializationCache.get().put(message, serializedBuffer.asReadOnlyBuffer());
            if (deserializationCache != null) {
                deserializationCache.put(new DeserializationKey(message.getClass(), serializedBuffer.asReadOnlyBuffer()), message);
            }
            return serializedBuffer;
        }
        return serializer.serialize(message);
    }

    private static final class EvictingMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final int MAX_SIZE = 30;

        public EvictingMap() {
            super(64, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 30;
        }
    }

    private static final class DeserializationKey {
        private Class<?> objectClass;
        private ByteBuffer bytes;

        public DeserializationKey(Class<?> objectClass, ByteBuffer bytes) {
            this.objectClass = objectClass;
            this.bytes = bytes;
        }

        public void setObjectClass(Class<?> objectClass) {
            this.objectClass = objectClass;
        }

        public void setBytes(ByteBuffer bytes) {
            this.bytes = bytes;
        }

        public DeserializationKey populate(Class<?> objectClass, ByteBuffer bytes) {
            this.objectClass = objectClass;
            this.bytes = bytes;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeserializationKey that = (DeserializationKey)o;
            return this.objectClass.equals(that.objectClass) && this.bytes.equals(that.bytes);
        }

        public int hashCode() {
            int result = this.objectClass.hashCode();
            result = 31 * result + this.bytes.hashCode();
            return result;
        }
    }
}

