/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.messaging.internal.ActorNodeMessage;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;
import org.elasticsoftware.elasticactors.util.ClassLoadingHelper;

public final class ActorNodeMessageDeserializer
implements MessageDeserializer<ActorNodeMessage> {
    private final ActorRefDeserializer actorRefDeserializer;
    private final InternalActorSystems cluster;

    public ActorNodeMessageDeserializer(ActorRefDeserializer actorRefDeserializer, InternalActorSystems cluster) {
        this.actorRefDeserializer = actorRefDeserializer;
        this.cluster = cluster;
    }

    public ActorNodeMessage deserialize(ByteBuffer serializedObject) throws IOException {
        try {
            Messaging.ActorNodeMessage protobufMessage = Messaging.ActorNodeMessage.parseFrom(ByteString.copyFrom((ByteBuffer)serializedObject));
            ActorRef receiverRef = this.getReceiver(protobufMessage);
            String messageClassString = protobufMessage.getPayloadClass();
            Class<?> messageClass = ClassLoadingHelper.getClassHelper().forName(messageClassString);
            Object payloadObject = this.cluster.get(null).getDeserializer(messageClass).deserialize(protobufMessage.getPayload().asReadOnlyByteBuffer());
            return new ActorNodeMessage(protobufMessage.getNodeId(), receiverRef, payloadObject, protobufMessage.getUndeliverable());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private ActorRef getReceiver(Messaging.ActorNodeMessage protobufMessage) throws IOException {
        String receiver = protobufMessage.getReceiver();
        return receiver.isEmpty() ? null : this.actorRefDeserializer.deserialize(receiver);
    }

    public Class<ActorNodeMessage> getMessageClass() {
        return ActorNodeMessage.class;
    }
}

