/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.messaging.internal.ActorNodeMessage;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefSerializer;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;

public final class ActorNodeMessageSerializer
implements MessageSerializer<ActorNodeMessage> {
    private final InternalActorSystems actorSystems;

    public ActorNodeMessageSerializer(InternalActorSystems actorSystems) {
        this.actorSystems = actorSystems;
    }

    public ByteBuffer serialize(ActorNodeMessage actorNodeMessage) throws IOException {
        Object message = actorNodeMessage.getMessage();
        Messaging.ActorNodeMessage.Builder builder = Messaging.ActorNodeMessage.newBuilder();
        builder.setReceiver(ActorRefSerializer.get().serialize(actorNodeMessage.getReceiverRef()));
        builder.setNodeId(actorNodeMessage.getNodeId());
        builder.setPayloadClass(message.getClass().getName());
        MessageSerializer serializer = this.actorSystems.get(null).getSerializer(message.getClass());
        builder.setPayload(ByteString.copyFrom((ByteBuffer)serializer.serialize(message)));
        builder.setUndeliverable(actorNodeMessage.isUndeliverable());
        return ByteBuffer.wrap(builder.build().toByteArray());
    }
}

