/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsoftware.elasticactors.ActorState;
import org.elasticsoftware.elasticactors.messaging.internal.ActorType;
import org.elasticsoftware.elasticactors.messaging.internal.CreateActorMessage;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;
import org.elasticsoftware.elasticactors.util.ClassLoadingHelper;
import org.elasticsoftware.elasticactors.util.SerializationTools;

public final class CreateActorMessageDeserializer
implements MessageDeserializer<CreateActorMessage> {
    private final SerializationFrameworks serializationFrameworks;

    public CreateActorMessageDeserializer(SerializationFrameworks serializationFrameworks) {
        this.serializationFrameworks = serializationFrameworks;
    }

    public CreateActorMessage deserialize(ByteBuffer serializedObject) throws IOException {
        Messaging.CreateActorMessage protobufMessage = Messaging.CreateActorMessage.parseFrom(ByteString.copyFrom((ByteBuffer)serializedObject));
        return new CreateActorMessage(protobufMessage.getActorSystem(), protobufMessage.getActorClass(), protobufMessage.getActorId(), this.getDeserializedState(protobufMessage), ActorType.values()[protobufMessage.getType().getNumber()], protobufMessage.getAffinityKey());
    }

    private ActorState getDeserializedState(Messaging.CreateActorMessage protobufMessage) throws IOException {
        return !protobufMessage.getInitialState().isEmpty() ? this.getDeserializeState(protobufMessage) : null;
    }

    private ActorState getDeserializeState(Messaging.CreateActorMessage protobufMessage) throws IOException {
        return this.deserializeState(protobufMessage.getActorClass(), protobufMessage.getInitialState().toByteArray());
    }

    private ActorState deserializeState(String actorClass, byte[] serializedState) throws IOException {
        try {
            return SerializationTools.deserializeActorState(this.serializationFrameworks, ClassLoadingHelper.getClassHelper().forName(actorClass), serializedState);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public Class<CreateActorMessage> getMessageClass() {
        return CreateActorMessage.class;
    }
}

