/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsoftware.elasticactors.ActorState;
import org.elasticsoftware.elasticactors.messaging.internal.CreateActorMessage;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;
import org.elasticsoftware.elasticactors.util.SerializationTools;

public final class CreateActorMessageSerializer
implements MessageSerializer<CreateActorMessage> {
    private final SerializationFrameworks serializationFrameworks;

    public CreateActorMessageSerializer(SerializationFrameworks serializationFrameworks) {
        this.serializationFrameworks = serializationFrameworks;
    }

    public ByteBuffer serialize(CreateActorMessage message) throws IOException {
        Messaging.CreateActorMessage.Builder builder = Messaging.CreateActorMessage.newBuilder();
        builder.setActorSystem(message.getActorSystem());
        builder.setActorClass(message.getActorClass());
        builder.setActorId(message.getActorId());
        if (message.getInitialState() != null) {
            builder.setInitialState(ByteString.copyFrom((byte[])this.serializeState(message.getInitialState())));
        }
        builder.setType(Messaging.ActorType.forNumber(message.getType().ordinal()));
        if (message.getAffinityKey() != null) {
            builder.setAffinityKey(message.getAffinityKey());
        }
        return ByteBuffer.wrap(builder.build().toByteArray());
    }

    private byte[] serializeState(ActorState state) throws IOException {
        return SerializationTools.serializeActorState(this.serializationFrameworks, state);
    }
}

