/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.UUID;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.messaging.DefaultInternalMessage;
import org.elasticsoftware.elasticactors.messaging.ImmutableInternalMessage;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.SerializationAccessor;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.CreationContextDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.TraceContextDeserializer;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.TraceContext;
import org.elasticsoftware.elasticactors.util.ClassLoadingHelper;

public final class InternalMessageDeserializer
implements Deserializer<byte[], InternalMessage> {
    private final ActorRefDeserializer actorRefDeserializer;
    private final SerializationAccessor serializationAccessor;

    public InternalMessageDeserializer(ActorRefDeserializer actorRefDeserializer, SerializationAccessor serializationAccessor) {
        this.actorRefDeserializer = actorRefDeserializer;
        this.serializationAccessor = serializationAccessor;
    }

    public InternalMessage deserialize(byte[] serializedObject) throws IOException {
        Messaging.InternalMessage protobufMessage = Messaging.InternalMessage.parseFrom(serializedObject);
        ActorRef sender = this.getSender(protobufMessage);
        ImmutableList<ActorRef> receivers = this.getReceivers(protobufMessage);
        String messageClassString = protobufMessage.getPayloadClass();
        UUID id = UUIDTools.toUUID(protobufMessage.getId().toByteArray());
        boolean durable = protobufMessage.getDurable();
        boolean undeliverable = protobufMessage.getUndeliverable();
        int timeout = protobufMessage.getTimeout() != 0 ? protobufMessage.getTimeout() : -1;
        TraceContext traceContext = protobufMessage.hasTraceContext() ? TraceContextDeserializer.deserialize(protobufMessage.getTraceContext()) : null;
        CreationContext creationContext = protobufMessage.hasCreationContext() ? CreationContextDeserializer.deserialize(protobufMessage.getCreationContext()) : null;
        Class<?> immutableMessageClass = this.getIfImmutableMessageClass(messageClassString);
        if (immutableMessageClass != null) {
            Object payloadObject = this.serializationAccessor.getDeserializer(immutableMessageClass).deserialize(protobufMessage.getPayload().asReadOnlyByteBuffer());
            return new ImmutableInternalMessage(id, sender, receivers, protobufMessage.getPayload().asReadOnlyByteBuffer(), payloadObject, durable, undeliverable, timeout, traceContext, creationContext);
        }
        String messageQueueAffinityKey = protobufMessage.hasMessageQueueAffinityKey() ? protobufMessage.getMessageQueueAffinityKey() : "";
        return new DefaultInternalMessage(id, sender, receivers, protobufMessage.getPayload().asReadOnlyByteBuffer(), messageClassString, messageQueueAffinityKey.isEmpty() ? null : messageQueueAffinityKey, durable, undeliverable, timeout, traceContext, creationContext);
    }

    private ImmutableList<ActorRef> getReceivers(Messaging.InternalMessage protobufMessage) throws IOException {
        ActorRef singleReceiver = this.getSingleReceiver(protobufMessage);
        if (singleReceiver != null) {
            return ImmutableList.of((Object)singleReceiver);
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String receiver : protobufMessage.getReceiversList()) {
            listBuilder.add((Object)this.actorRefDeserializer.deserialize(receiver));
        }
        return listBuilder.build();
    }

    private ActorRef getSender(Messaging.InternalMessage protobufMessage) throws IOException {
        if (protobufMessage.hasSender()) {
            return this.deserializeActorRef(protobufMessage.getSender());
        }
        return null;
    }

    private ActorRef getSingleReceiver(Messaging.InternalMessage protobufMessage) throws IOException {
        if (protobufMessage.hasReceiver()) {
            return this.deserializeActorRef(protobufMessage.getReceiver());
        }
        return null;
    }

    private ActorRef deserializeActorRef(String actorRef) throws IOException {
        return actorRef.isEmpty() ? null : this.actorRefDeserializer.deserialize(actorRef);
    }

    private Class<?> getIfImmutableMessageClass(String messageClassString) {
        try {
            Class<?> messageClass = ClassLoadingHelper.getClassHelper().forName(messageClassString);
            Message messageAnnotation = messageClass.getAnnotation(Message.class);
            if (messageAnnotation != null && messageAnnotation.immutable()) {
                return messageClass;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

