/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.CreationContextSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.TraceContextSerializer;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;

public final class InternalMessageSerializer
implements Serializer<InternalMessage, byte[]> {
    private static final InternalMessageSerializer INSTANCE = new InternalMessageSerializer();

    public static InternalMessageSerializer get() {
        return INSTANCE;
    }

    public byte[] serialize(InternalMessage internalMessage) {
        String messageQueueAffinityKey;
        Messaging.CreationContext creationContext;
        Messaging.InternalMessage.Builder builder = Messaging.InternalMessage.newBuilder();
        builder.setId(ByteString.copyFrom((byte[])UUIDTools.toByteArray(internalMessage.getId())));
        builder.setPayload(ByteString.copyFrom((ByteBuffer)internalMessage.getPayload()));
        builder.setPayloadClass(internalMessage.getPayloadClass());
        if (internalMessage.getReceivers().size() == 1) {
            builder.setReceiver(ActorRefSerializer.get().serialize((ActorRef)internalMessage.getReceivers().get(0)));
        } else {
            for (ActorRef receiver : internalMessage.getReceivers()) {
                builder.addReceivers(ActorRefSerializer.get().serialize(receiver));
            }
        }
        if (internalMessage.getSender() != null) {
            builder.setSender(ActorRefSerializer.get().serialize(internalMessage.getSender()));
        }
        builder.setDurable(internalMessage.isDurable());
        builder.setUndeliverable(internalMessage.isUndeliverable());
        builder.setTimeout(internalMessage.getTimeout());
        Messaging.TraceContext traceContext = TraceContextSerializer.serialize(internalMessage.getTraceContext());
        if (traceContext != null) {
            builder.setTraceContext(traceContext);
        }
        if ((creationContext = CreationContextSerializer.serialize(internalMessage.getCreationContext())) != null) {
            builder.setCreationContext(creationContext);
        }
        if ((messageQueueAffinityKey = internalMessage.getMessageQueueAffinityKey()) != null) {
            builder.setMessageQueueAffinityKey(messageQueueAffinityKey);
        }
        return builder.build().toByteArray();
    }
}

