/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import java.io.IOException;
import java.util.UUID;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessage;
import org.elasticsoftware.elasticactors.messaging.ScheduledMessageImpl;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.CreationContextDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.TraceContextDeserializer;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.TraceContext;
import org.elasticsoftware.elasticactors.util.ClassLoadingHelper;

public final class ScheduledMessageDeserializer
implements Deserializer<byte[], ScheduledMessage> {
    private final ActorRefDeserializer actorRefDeserializer;

    public ScheduledMessageDeserializer(ActorRefDeserializer actorRefDeserializer) {
        this.actorRefDeserializer = actorRefDeserializer;
    }

    public ScheduledMessage deserialize(byte[] serializedObject) throws IOException {
        try {
            Messaging.ScheduledMessage protobufMessage = Messaging.ScheduledMessage.parseFrom(serializedObject);
            ActorRef sender = this.getSender(protobufMessage);
            ActorRef receiver = this.actorRefDeserializer.deserialize(protobufMessage.getReceiver());
            Class<?> messageClass = ClassLoadingHelper.getClassHelper().forName(protobufMessage.getMessageClass());
            byte[] messageBytes = protobufMessage.getMessage().toByteArray();
            UUID id = UUIDTools.toUUID(protobufMessage.getId().toByteArray());
            long fireTime = protobufMessage.getFireTime();
            TraceContext traceContext = protobufMessage.hasTraceContext() ? TraceContextDeserializer.deserialize(protobufMessage.getTraceContext()) : null;
            CreationContext creationContext = protobufMessage.hasCreationContext() ? CreationContextDeserializer.deserialize(protobufMessage.getCreationContext()) : null;
            String messageQueueAffinityKey = protobufMessage.hasMessageQueueAffinityKey() ? protobufMessage.getMessageQueueAffinityKey() : "";
            return new ScheduledMessageImpl(id, fireTime, sender, receiver, messageClass, messageBytes, messageQueueAffinityKey.isEmpty() ? null : messageQueueAffinityKey, traceContext, creationContext);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private ActorRef getSender(Messaging.ScheduledMessage protobufMessage) throws IOException {
        if (protobufMessage.hasSender()) {
            String senderStr = protobufMessage.getSender();
            return senderStr.isEmpty() ? null : this.actorRefDeserializer.deserialize(senderStr);
        }
        return null;
    }
}

