/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.protobuf.ByteString;
import java.util.concurrent.TimeUnit;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessage;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.CreationContextSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.tracing.TraceContextSerializer;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;

public final class ScheduledMessageSerializer
implements Serializer<ScheduledMessage, byte[]> {
    private static final ScheduledMessageSerializer INSTANCE = new ScheduledMessageSerializer();

    public static ScheduledMessageSerializer get() {
        return INSTANCE;
    }

    public byte[] serialize(ScheduledMessage scheduledMessage) {
        String messageAffinityKey;
        Messaging.CreationContext creationContext;
        Messaging.ScheduledMessage.Builder builder = Messaging.ScheduledMessage.newBuilder();
        builder.setId(ByteString.copyFrom((byte[])UUIDTools.toByteArray(scheduledMessage.getId())));
        builder.setFireTime(scheduledMessage.getFireTime(TimeUnit.MILLISECONDS));
        builder.setMessageClass(scheduledMessage.getMessageClass().getName());
        builder.setSender(scheduledMessage.getSender().toString());
        builder.setReceiver(scheduledMessage.getReceiver().toString());
        builder.setMessage(ByteString.copyFrom((byte[])scheduledMessage.getMessageBytes()));
        Messaging.TraceContext traceContext = TraceContextSerializer.serialize(scheduledMessage.getTraceContext());
        if (traceContext != null) {
            builder.setTraceContext(traceContext);
        }
        if ((creationContext = CreationContextSerializer.serialize(scheduledMessage.getCreationContext())) != null) {
            builder.setCreationContext(creationContext);
        }
        if ((messageAffinityKey = scheduledMessage.getMessageQueueAffinityKey()) != null) {
            builder.setMessageQueueAffinityKey(messageAffinityKey);
        }
        return builder.build().toByteArray();
    }
}

