/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.util;

import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassLoadingHelper {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoadingHelper.class);

    @Nonnull
    public abstract Class<?> forName(@Nonnull String var1) throws ClassNotFoundException;

    public abstract boolean isCachingEnabled();

    public static ClassLoadingHelper getClassHelper() {
        return ClassLoadingHelperHolder.INSTANCE;
    }

    private static final class SimpleClassLoadingHelper
    extends ClassLoadingHelper {
        private SimpleClassLoadingHelper() {
        }

        @Override
        @Nonnull
        public Class<?> forName(@Nonnull String className) throws ClassNotFoundException {
            return Class.forName(className);
        }

        @Override
        public boolean isCachingEnabled() {
            return false;
        }
    }

    private static final class ClassLoadingHelperHolder {
        private static final ClassLoadingHelper INSTANCE = ClassLoadingHelperHolder.loadService();

        private ClassLoadingHelperHolder() {
        }

        private static ClassLoadingHelper loadService() {
            try {
                return Optional.of(ServiceLoader.load(ClassLoadingHelper.class)).map(ServiceLoader::iterator).filter(Iterator::hasNext).map(ClassLoadingHelperHolder::loadFirst).orElseGet(() -> {
                    logger.warn("No implementations of ClassLoadingHelper were found. Using the simple, non-caching implementation.");
                    return new SimpleClassLoadingHelper();
                });
            }
            catch (Exception e) {
                logger.error("Exception thrown while loading ClassLoadingHelper implementation. Using the simple, non-caching implementation.", (Throwable)e);
                return new SimpleClassLoadingHelper();
            }
        }

        private static ClassLoadingHelper loadFirst(Iterator<ClassLoadingHelper> iter) {
            ClassLoadingHelper service = iter.next();
            logger.info("Loaded ClassLoadingHelper implementation [{}]. Caching enabled: {}", (Object)service.getClass().getName(), (Object)service.isCachingEnabled());
            return service;
        }
    }
}

