/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.util;

import java.io.IOException;
import org.elasticsoftware.elasticactors.Actor;
import org.elasticsoftware.elasticactors.ActorState;
import org.elasticsoftware.elasticactors.ElasticActor;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.MessageToStringConverter;
import org.elasticsoftware.elasticactors.serialization.SerializationAccessor;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.util.ClassLoadingHelper;

public final class SerializationTools {
    public static Object deserializeMessage(SerializationAccessor serializationAccessor, InternalMessage internalMessage) throws Exception {
        Class<?> messageClass = ClassLoadingHelper.getClassHelper().forName(internalMessage.getPayloadClass());
        MessageDeserializer deserializer = serializationAccessor.getDeserializer(messageClass);
        if (deserializer != null) {
            return internalMessage.getPayload(deserializer);
        }
        throw new Exception(String.format("No Deserializer found for Message class %s", internalMessage.getPayloadClass()));
    }

    public static MessageToStringConverter getStringConverter(SerializationFrameworks serializationFrameworks, Class<?> messageClass) {
        SerializationFramework serializationFramework;
        Message messageAnnotation = messageClass.getAnnotation(Message.class);
        if (messageAnnotation != null && (serializationFramework = serializationFrameworks.getSerializationFramework(messageAnnotation.serializationFramework())) != null) {
            return serializationFramework.getToStringConverter();
        }
        return null;
    }

    public static ActorState deserializeActorState(SerializationFrameworks serializationFrameworks, Class<? extends ElasticActor> actorClass, byte[] serializedState) throws IOException {
        Actor actorAnnotation = actorClass.getAnnotation(Actor.class);
        if (actorAnnotation != null) {
            SerializationFramework framework = serializationFrameworks.getSerializationFramework(actorAnnotation.serializationFramework());
            return (ActorState)framework.getActorStateDeserializer(actorClass).deserialize((Object)serializedState);
        }
        return null;
    }

    public static byte[] serializeActorState(SerializationFrameworks serializationFrameworks, Class<? extends ElasticActor> actorClass, ActorState actorState) throws IOException {
        Actor actorAnnotation = actorClass.getAnnotation(Actor.class);
        if (actorAnnotation != null) {
            SerializationFramework framework = serializationFrameworks.getSerializationFramework(actorAnnotation.serializationFramework());
            return (byte[])framework.getActorStateSerializer(actorClass).serialize((Object)actorState);
        }
        return null;
    }

    public static byte[] serializeActorState(SerializationFrameworks serializationFrameworks, ActorState actorState) throws IOException {
        SerializationFramework framework = serializationFrameworks.getSerializationFramework(actorState.getSerializationFramework());
        return (byte[])framework.getActorStateSerializer(actorState).serialize((Object)actorState);
    }

    public static SerializationFramework getSerializationFramework(SerializationFrameworks serializationFrameworks, Class<? extends ElasticActor> actorClass) {
        Actor actorAnnotation = actorClass.getAnnotation(Actor.class);
        if (actorAnnotation != null) {
            return serializationFrameworks.getSerializationFramework(actorAnnotation.serializationFramework());
        }
        return null;
    }
}

