/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.InternalActorSystemConfiguration;
import org.elasticsoftware.elasticactors.ManagedActorsRegistry;
import org.elasticsoftware.elasticactors.PhysicalNode;
import org.elasticsoftware.elasticactors.base.serialization.ObjectMapperBuilder;
import org.elasticsoftware.elasticactors.cache.NodeActorCacheManager;
import org.elasticsoftware.elasticactors.cache.ShardActorCacheManager;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListenerService;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventRegistryImpl;
import org.elasticsoftware.elasticactors.cluster.HashingNodeSelectorFactory;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.cluster.LocalActorSystemInstance;
import org.elasticsoftware.elasticactors.cluster.NodeSelectorFactory;
import org.elasticsoftware.elasticactors.cluster.RemoteActorSystems;
import org.elasticsoftware.elasticactors.cluster.logging.LoggingSettings;
import org.elasticsoftware.elasticactors.cluster.metrics.MetricsSettings;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageRefFactory;
import org.elasticsoftware.elasticactors.cluster.scheduler.ShardedScheduler;
import org.elasticsoftware.elasticactors.health.InternalActorSystemHealthCheck;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactoryFactory;
import org.elasticsoftware.elasticactors.runtime.ActorLifecycleListenerScanner;
import org.elasticsoftware.elasticactors.runtime.DefaultConfiguration;
import org.elasticsoftware.elasticactors.runtime.ElasticActorsNode;
import org.elasticsoftware.elasticactors.runtime.ManagedActorsScanner;
import org.elasticsoftware.elasticactors.runtime.MessagesScanner;
import org.elasticsoftware.elasticactors.runtime.PluggableMessageHandlersScanner;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.SystemSerializationFramework;
import org.elasticsoftware.elasticactors.state.ActorStateUpdateListener;
import org.elasticsoftware.elasticactors.state.ActorStateUpdateProcessor;
import org.elasticsoftware.elasticactors.state.DefaultActorStateUpdateProcessor;
import org.elasticsoftware.elasticactors.state.NoopActorStateUpdateProcessor;
import org.elasticsoftware.elasticactors.util.concurrent.DaemonThreadFactory;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutor;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutorImpl;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class NodeConfiguration {
    private static final String EA_LOGGING_MESSAGES_OVERRIDES = "ea.logging.messages.overrides.";

    @Bean(name={"elasticActorsNode", "actorSystems", "actorRefFactory", "serializationFrameworks"})
    @DependsOn(value={"messageHandlersRegistry", "managedActorsRegistry", "actorLifecycleListenerRegistry"})
    public ElasticActorsNode createElasticActorsNode(Environment env, @Qualifier(value="actorRefCache") Cache<String, ActorRef> actorRefCache) throws UnknownHostException {
        String nodeId = env.getRequiredProperty("ea.node.id");
        InetAddress nodeAddress = InetAddress.getByName(env.getRequiredProperty("ea.node.address"));
        String clusterName = env.getRequiredProperty("ea.cluster");
        return new ElasticActorsNode(clusterName, nodeId, nodeAddress, actorRefCache);
    }

    @Bean(name={"actorRefCache"})
    public Cache<String, ActorRef> createActorRefCache(Environment env) {
        int maximumSize = (Integer)env.getProperty("ea.actorRefCache.maximumSize", Integer.class, (Object)10240);
        return CacheBuilder.newBuilder().maximumSize((long)maximumSize).build();
    }

    @Bean(name={"actorSystemConfiguration"})
    public InternalActorSystemConfiguration createConfiguration(ResourceLoader resourceLoader, Environment env) throws IOException {
        Resource configResource = resourceLoader.getResource(env.getProperty("ea.node.config.location", "classpath:ea-default.yaml"));
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (InternalActorSystemConfiguration)objectMapper.readValue(configResource.getInputStream(), DefaultConfiguration.class);
    }

    @Bean(name={"objectMapperBuilder"})
    public ObjectMapperBuilder createObjectMapperBuilder(ShardedScheduler schedulerService, Environment env, ElasticActorsNode node) {
        String basePackages = (String)env.getProperty("ea.scan.packages", String.class, (Object)"");
        Boolean useAfterburner = (Boolean)env.getProperty("ea.base.useAfterburner", Boolean.class, (Object)Boolean.FALSE);
        ObjectMapperBuilder builder = new ObjectMapperBuilder((ActorRefFactory)node, (ScheduledMessageRefFactory)schedulerService, basePackages, "1.0.0");
        builder.setUseAfterBurner(useAfterburner.booleanValue());
        return builder;
    }

    @Bean(name={"systemSerializationFramework"})
    public SystemSerializationFramework createSystemSerializationFramework(SerializationFrameworks serializationFrameworks) {
        return new SystemSerializationFramework(serializationFrameworks);
    }

    @Bean(name={"managedActorsRegistry"})
    public ManagedActorsScanner createManagedActorsScanner(ApplicationContext applicationContext) {
        return new ManagedActorsScanner(applicationContext);
    }

    @Bean(name={"messagesScanner"})
    public MessagesScanner createMessageScanner(ApplicationContext applicationContext) {
        return new MessagesScanner(applicationContext);
    }

    @Bean(name={"messageHandlersRegistry"})
    public PluggableMessageHandlersScanner createPluggableMessagesHandlersScanner(ApplicationContext applicationContext) {
        return new PluggableMessageHandlersScanner(applicationContext);
    }

    @Bean(name={"actorLifecycleListenerRegistry"})
    public ActorLifecycleListenerScanner createActorLifecycleListenerScanner(ApplicationContext applicationContext) {
        return new ActorLifecycleListenerScanner(applicationContext);
    }

    @Bean(name={"nodeSelectorFactory"})
    public NodeSelectorFactory getNodeSelectorFactory() {
        return new HashingNodeSelectorFactory();
    }

    @Bean(name={"nodeActorCacheManager"})
    public NodeActorCacheManager createNodeActorCacheManager(Environment env) {
        int maximumSize = (Integer)env.getProperty("ea.nodeCache.maximumSize", Integer.class, (Object)10240);
        return new NodeActorCacheManager(maximumSize);
    }

    @Bean(name={"shardActorCacheManager"})
    public ShardActorCacheManager createShardActorCacheManager(Environment env) {
        int maximumSize = (Integer)env.getProperty("ea.shardCache.maximumSize", Integer.class, (Object)10240);
        return new ShardActorCacheManager(maximumSize);
    }

    @Bean(name={"actorExecutor"}, destroyMethod="shutdown")
    @DependsOn(value={"asyncUpdateExecutor"})
    public ThreadBoundExecutor createActorExecutor(Environment env) {
        int workers = (Integer)env.getProperty("ea.actorExecutor.workerCount", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() * 3));
        Boolean useDisruptor = (Boolean)env.getProperty("ea.actorExecutor.useDisruptor", Boolean.class, (Object)Boolean.FALSE);
        if (useDisruptor.booleanValue()) {
            return new org.elasticsoftware.elasticactors.util.concurrent.disruptor.ThreadBoundExecutorImpl((ThreadFactory)new DaemonThreadFactory("ACTOR-WORKER"), workers);
        }
        return new ThreadBoundExecutorImpl((ThreadFactory)new DaemonThreadFactory("ACTOR-WORKER"), workers);
    }

    @Bean(name={"queueExecutor"}, destroyMethod="shutdown")
    @DependsOn(value={"actorExecutor"})
    public ThreadBoundExecutor createQueueExecutor(Environment env) {
        int workers = (Integer)env.getProperty("ea.queueExecutor.workerCount", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() * 3));
        Boolean useDisruptor = (Boolean)env.getProperty("ea.queueExecutor.useDisruptor", Boolean.class, (Object)Boolean.FALSE);
        if (useDisruptor.booleanValue()) {
            return new org.elasticsoftware.elasticactors.util.concurrent.disruptor.ThreadBoundExecutorImpl((ThreadFactory)new DaemonThreadFactory("QUEUE-WORKER"), workers);
        }
        return new ThreadBoundExecutorImpl((ThreadFactory)new DaemonThreadFactory("QUEUE-WORKER"), workers);
    }

    @Bean(name={"internalActorSystem"}, destroyMethod="shutdown")
    public InternalActorSystem createLocalActorSystemInstance(ElasticActorsNode node, @Qualifier(value="actorSystemConfiguration") InternalActorSystemConfiguration configuration, ManagedActorsRegistry managedActorsRegistry, NodeSelectorFactory nodeSelectorFactory) {
        return new LocalActorSystemInstance((PhysicalNode)node, (InternalActorSystems)node, configuration, nodeSelectorFactory, managedActorsRegistry);
    }

    @Bean(name={"remoteActorSystems"})
    public RemoteActorSystems createRemoteActorSystems(ElasticActorsNode node, @Qualifier(value="actorSystemConfiguration") InternalActorSystemConfiguration configuration, @Qualifier(value="remoteActorSystemMessageQueueFactoryFactory") MessageQueueFactoryFactory remoteActorSystemMessageQueueFactoryFactory) {
        return new RemoteActorSystems(configuration, (InternalActorSystems)node, remoteActorSystemMessageQueueFactoryFactory);
    }

    @Bean(name={"scheduler"})
    public ShardedScheduler createScheduler(Environment env) {
        int numberOfWorkers = (Integer)env.getProperty("ea.shardedScheduler.workerCount", Integer.class, (Object)Runtime.getRuntime().availableProcessors());
        return new ShardedScheduler(numberOfWorkers);
    }

    @Bean(name={"actorSystemEventListenerService"})
    public ActorSystemEventListenerService createActorSystemEventListenerService(ActorSystemEventListenerRepository eventListenerRepository, InternalActorSystem actorSystem) {
        return new ActorSystemEventRegistryImpl(eventListenerRepository, actorSystem);
    }

    @Bean(name={"internalActorSystemHealthCheck"})
    public InternalActorSystemHealthCheck createHealthCheck(InternalActorSystem internalActorSystem) {
        return new InternalActorSystemHealthCheck(internalActorSystem);
    }

    @Bean(name={"actorStateUpdateProcessor"})
    public ActorStateUpdateProcessor createActorStateUpdateProcessor(ApplicationContext applicationContext, Environment env) {
        Map listeners = applicationContext.getBeansOfType(ActorStateUpdateListener.class);
        if (listeners.isEmpty()) {
            return new NoopActorStateUpdateProcessor();
        }
        int workers = (Integer)env.getProperty("ea.actorStateUpdateProcessor.workerCount", Integer.class, (Object)1);
        int maxBatchSize = (Integer)env.getProperty("ea.actorStateUpdateProcessor.maxBatchSize", Integer.class, (Object)20);
        return new DefaultActorStateUpdateProcessor(listeners.values(), workers, maxBatchSize);
    }

    @Bean(name={"nodeMetricsSettings"})
    public MetricsSettings nodeMetricsSettings(Environment environment) {
        boolean metricsEnabled = (Boolean)environment.getProperty("ea.metrics.node.messaging.enabled", Boolean.class, (Object)false);
        long messageDeliveryWarnThreshold = (Long)environment.getProperty("ea.metrics.node.messaging.delivery.warn.threshold", Long.class, (Object)0L);
        long messageHandlingWarnThreshold = (Long)environment.getProperty("ea.metrics.node.messaging.handling.warn.threshold", Long.class, (Object)0L);
        return new MetricsSettings(metricsEnabled, messageDeliveryWarnThreshold, messageHandlingWarnThreshold, 0L);
    }

    @Bean(name={"shardMetricsSettings"})
    public MetricsSettings shardMetricsSettings(Environment environment) {
        boolean metricsEnabled = (Boolean)environment.getProperty("ea.metrics.shard.messaging.enabled", Boolean.class, (Object)false);
        long messageDeliveryWarnThreshold = (Long)environment.getProperty("ea.metrics.shard.messaging.delivery.warn.threshold", Long.class, (Object)0L);
        long messageHandlingWarnThreshold = (Long)environment.getProperty("ea.metrics.shard.messaging.handling.warn.threshold", Long.class, (Object)0L);
        long serializationWarnThreshold = (Long)environment.getProperty("ea.metrics.shard.serialization.warn.threshold", Long.class, (Object)0L);
        return new MetricsSettings(metricsEnabled, messageDeliveryWarnThreshold, messageHandlingWarnThreshold, serializationWarnThreshold);
    }

    @Bean(name={"nodeLoggingSettings"})
    public LoggingSettings nodeLoggingSettings(Environment environment) {
        boolean loggingEnabled = (Boolean)environment.getProperty("ea.logging.node.messaging.enabled", Boolean.class, (Object)false);
        return new LoggingSettings(loggingEnabled, this.buildOverridesMap(environment));
    }

    @Bean(name={"shardLoggingSettings"})
    public LoggingSettings shardLoggingSettings(Environment environment) {
        boolean loggingEnabled = (Boolean)environment.getProperty("ea.logging.shard.messaging.enabled", Boolean.class, (Object)false);
        return new LoggingSettings(loggingEnabled, this.buildOverridesMap(environment));
    }

    private ImmutableMap<String, Message.LogFeature[]> buildOverridesMap(Environment environment) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (environment instanceof ConfigurableEnvironment) {
            for (PropertySource propertySource : ((ConfigurableEnvironment)environment).getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                String[] stringArray = ((EnumerablePropertySource)propertySource).getPropertyNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object property;
                    String key = stringArray[n2];
                    if (key.length() > EA_LOGGING_MESSAGES_OVERRIDES.length() && key.startsWith(EA_LOGGING_MESSAGES_OVERRIDES) && (property = propertySource.getProperty(key)) != null) {
                        String value = property.toString();
                        Message.LogFeature[] features = (Message.LogFeature[])Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toUpperCase).map(Message.LogFeature::valueOf).distinct().toArray(Message.LogFeature[]::new);
                        String className = key.substring(EA_LOGGING_MESSAGES_OVERRIDES.length());
                        mapBuilder.put((Object)className, (Object)features);
                    }
                    ++n2;
                }
            }
        }
        return mapBuilder.build();
    }
}

