/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.runtime;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsoftware.elasticactors.ElasticActor;
import org.elasticsoftware.elasticactors.InternalActorSystemConfiguration;
import org.elasticsoftware.elasticactors.ServiceActor;
import org.elasticsoftware.elasticactors.runtime.DefaultRemoteConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public final class DefaultConfiguration
implements InternalActorSystemConfiguration,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final String name;
    private final int numberOfShards;
    private final int queuesPerShard;
    private final int queuesPerNode;
    private final int shardHashSeed;
    private final int multiQueueHashSeed;
    private final int shardDistributionHashSeed;
    private final List<DefaultRemoteConfiguration> remoteConfigurations;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final ConversionService conversionService = new DefaultConversionService();
    private final Map<String, ElasticActor> serviceActors = new ConcurrentHashMap<String, ElasticActor>();
    private final Map<Class<?>, String> componentNameCache = new ConcurrentHashMap();

    @JsonCreator
    public DefaultConfiguration(@JsonProperty(value="name") String name, @JsonProperty(value="shards") int numberOfShards, @JsonProperty(value="queuesPerShard") Integer queuesPerShard, @JsonProperty(value="queuesPerNode") Integer queuesPerNode, @JsonProperty(value="shardHashSeed") Integer shardHashSeed, @JsonProperty(value="multiQueueHashSeed") Integer multiQueueHashSeed, @JsonProperty(value="shardDistributionHashSeed") Integer shardDistributionHashSeed, @JsonProperty(value="remoteActorSystems") List<DefaultRemoteConfiguration> remoteConfigurations) {
        this.name = name;
        this.numberOfShards = numberOfShards;
        this.queuesPerShard = queuesPerShard != null ? queuesPerShard : 1;
        this.queuesPerNode = queuesPerNode != null ? queuesPerNode : 1;
        this.shardHashSeed = shardHashSeed != null ? shardHashSeed : 0;
        this.multiQueueHashSeed = multiQueueHashSeed != null ? multiQueueHashSeed : 53;
        this.shardDistributionHashSeed = shardDistributionHashSeed != null ? shardDistributionHashSeed : 53;
        this.remoteConfigurations = remoteConfigurations != null ? remoteConfigurations : Collections.emptyList();
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="shards")
    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    @JsonAnySetter
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public String getVersion() {
        return "1.0.0";
    }

    @JsonProperty(value="queuesPerShard")
    public int getQueuesPerShard() {
        return this.queuesPerShard;
    }

    @JsonProperty(value="queuesPerNode")
    public int getQueuesPerNode() {
        return this.queuesPerNode;
    }

    @JsonProperty(value="shardHashSeed")
    public int getShardHashSeed() {
        return this.shardHashSeed;
    }

    @JsonProperty(value="multiQueueHashSeed")
    public int getMultiQueueHashSeed() {
        return this.multiQueueHashSeed;
    }

    @JsonProperty(value="shardDistributionHashSeed")
    public int getShardDistributionHashSeed() {
        return this.shardDistributionHashSeed;
    }

    public ElasticActor<?> getService(String serviceId) {
        return this.serviceActors.computeIfAbsent(serviceId, id -> (ElasticActor)this.applicationContext.getBean(id, ElasticActor.class));
    }

    public Set<String> getServices() {
        return this.applicationContext.getBeansWithAnnotation(ServiceActor.class).keySet();
    }

    public <T> T getProperty(Class component, String key, Class<T> targetType) {
        Object value;
        Map componentProperties = (Map)this.properties.get(this.generateComponentName(component));
        if (componentProperties == null) {
            componentProperties = (Map)this.properties.get(component.getName());
        }
        if (componentProperties != null && (value = componentProperties.get(key)) != null && this.conversionService.canConvert(value.getClass(), targetType)) {
            return (T)this.conversionService.convert(value, targetType);
        }
        return null;
    }

    public <T> T getProperty(Class component, String key, Class<T> targetType, T defaultValue) {
        T value = this.getProperty(component, key, targetType);
        return value != null ? value : defaultValue;
    }

    public <T> T getRequiredProperty(Class component, String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(component, key, targetType);
        if (value == null) {
            throw new IllegalStateException(String.format("required key [%s] not found for component[%s]", key, component.getName()));
        }
        return value;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private String generateComponentName(Class component) {
        return this.componentNameCache.computeIfAbsent(component, componentClass -> {
            String componentName = componentClass.getName();
            int idx = componentName.indexOf(46, componentName.indexOf(46) + 1);
            if (idx != -1) {
                componentName = componentName.substring(idx + 1);
            }
            return componentName;
        });
    }

    @JsonProperty(value="remoteActorSystems")
    public List<DefaultRemoteConfiguration> getRemoteConfigurations() {
        return this.remoteConfigurations;
    }
}

