/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.runtime;

import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.elasticsoftware.elasticactors.Actor;
import org.elasticsoftware.elasticactors.ElasticActor;
import org.elasticsoftware.elasticactors.ManagedActor;
import org.elasticsoftware.elasticactors.ManagedActorsRegistry;
import org.elasticsoftware.elasticactors.ServiceActor;
import org.elasticsoftware.elasticactors.SingletonActor;
import org.elasticsoftware.elasticactors.runtime.ScannerHelper;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class ManagedActorsScanner
implements ManagedActorsRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ManagedActorsScanner.class);
    private final ApplicationContext applicationContext;
    private ImmutableList<Class<? extends ElasticActor<?>>> singletonActorClasses;
    private ImmutableList<Class<? extends ElasticActor<?>>> managedActorClasses;

    public ManagedActorsScanner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public synchronized void init() {
        logger.info("Scanning Managed Actor classes");
        String[] basePackages = ScannerHelper.findBasePackagesOnClasspath(this.applicationContext.getClassLoader(), new String[0]);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        logger.debug("Scanning the following base packages: {}", (Object)basePackages);
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            configurationBuilder.addUrls(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[0]));
            ++n2;
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        logger.info("Scanning @SingletonActor-annotated classes");
        this.singletonActorClasses = (ImmutableList)reflections.getTypesAnnotatedWith(SingletonActor.class).stream().filter(ElasticActor.class::isAssignableFrom).filter(c -> c.isAnnotationPresent(Actor.class)).filter(c -> !c.isAnnotationPresent(ManagedActor.class)).filter(c -> !c.isAnnotationPresent(ServiceActor.class)).map(c -> c).collect(ImmutableList.toImmutableList());
        logger.info("Found {} classes annotated with @SingletonActor", (Object)this.singletonActorClasses.size());
        if (logger.isDebugEnabled()) {
            logger.debug("Found the following classes annotated with @SingletonActor: {}", this.singletonActorClasses.stream().map(Class::getName).collect(Collectors.toList()));
        }
        logger.info("Scanning @ManagedActor-annotated classes");
        this.managedActorClasses = (ImmutableList)reflections.getTypesAnnotatedWith(ManagedActor.class).stream().filter(ElasticActor.class::isAssignableFrom).filter(c -> c.isAnnotationPresent(Actor.class)).filter(c -> !c.isAnnotationPresent(SingletonActor.class)).filter(c -> !c.isAnnotationPresent(ServiceActor.class)).map(c -> c).collect(ImmutableList.toImmutableList());
        logger.info("Found {} classes annotated with @ManagedActor", (Object)this.managedActorClasses.size());
        if (logger.isDebugEnabled()) {
            logger.debug("Found the following classes annotated with @ManagedActor: {}", this.managedActorClasses.stream().map(Class::getName).collect(Collectors.toList()));
        }
    }

    public ImmutableList<Class<? extends ElasticActor<?>>> getSingletonActorClasses() {
        return this.singletonActorClasses;
    }

    public ImmutableList<Class<? extends ElasticActor<?>>> getManagedActorClasses() {
        return this.managedActorClasses;
    }
}

