/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cluster;

import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsoftware.elasticactors.messaging.Hasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistentHash<T> {
    private static final Logger logger = LoggerFactory.getLogger(ConsistentHash.class);
    private final Hasher hasher;
    private final int numberOfReplicas;
    private final SortedMap<Long, T> circle = new TreeMap<Long, T>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ConsistentHash(Hasher hasher, int numberOfReplicas, Collection<T> nodes) {
        this.hasher = hasher;
        this.numberOfReplicas = numberOfReplicas;
        for (T node : nodes) {
            this.internalAdd(node);
        }
    }

    public void add(T node) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.internalAdd(node);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void internalAdd(T node) {
        int i = 0;
        while (i < this.numberOfReplicas) {
            T previous = this.circle.put(this.hasher.hashStringToLong(this.buildReplicaName(node, i)), node);
            if (previous != null) {
                logger.warn("Detected collision between {} and {}. Distribution might be affected.", previous, node);
            }
            ++i;
        }
    }

    public void remove(T node) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.internalRemove(node);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void internalRemove(T node) {
        int i = 0;
        while (i < this.numberOfReplicas) {
            this.circle.remove(this.hasher.hashStringToLong(this.buildReplicaName(node, i)));
            ++i;
        }
    }

    private String buildReplicaName(T node, int i) {
        return String.valueOf(node.toString()) + "-" + i;
    }

    public T get(String key) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            if (this.circle.isEmpty()) {
                return null;
            }
            long hash = this.hasher.hashStringToLong(key);
            if (!this.circle.containsKey(hash)) {
                SortedMap<Long, T> tailMap = this.circle.tailMap(hash);
                hash = tailMap.isEmpty() ? this.circle.firstKey() : tailMap.firstKey();
            }
            Object v = this.circle.get(hash);
            return (T)v;
        }
        finally {
            readLock.unlock();
        }
    }
}

