/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.runtime;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.elasticsoftware.elasticactors.ActorLifecycleListener;
import org.elasticsoftware.elasticactors.ActorLifecycleListenerRegistry;
import org.elasticsoftware.elasticactors.ElasticActor;
import org.elasticsoftware.elasticactors.runtime.ScannerHelper;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class ActorLifecycleListenerScanner
implements ActorLifecycleListenerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ActorLifecycleListenerScanner.class);
    private final ApplicationContext applicationContext;
    private final ListMultimap<Class<? extends ElasticActor>, ActorLifecycleListener<?>> registry = LinkedListMultimap.create();

    public ActorLifecycleListenerScanner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public synchronized void init() {
        logger.info("Scanning classes that implement ActorLifecycleListener");
        String[] basePackages = ScannerHelper.findBasePackagesOnClasspath(this.applicationContext.getClassLoader(), new String[0]);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        logger.debug("Scanning the following base packages: {}", (Object)basePackages);
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            configurationBuilder.addUrls(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[0]));
            ++n2;
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set listenerClasses = reflections.getSubTypesOf(ActorLifecycleListener.class);
        logger.info("Found {} classes that implement ActorLifecycleListener", (Object)listenerClasses.size());
        if (logger.isDebugEnabled()) {
            logger.debug("Found the following classes implementing ActorLifecycleListener: {}", listenerClasses.stream().map(Class::getName).collect(Collectors.toList()));
        }
        for (Class listenerClass : listenerClasses) {
            try {
                ActorLifecycleListener lifeCycleListener = (ActorLifecycleListener)listenerClass.newInstance();
                logger.debug("Registering instance of ActorLifecycleListener class [{}] for Actor class [{}]", (Object)listenerClass.getName(), (Object)lifeCycleListener.getActorClass().getName());
                this.registry.put((Object)lifeCycleListener.getActorClass(), (Object)lifeCycleListener);
            }
            catch (Exception e) {
                logger.error("Exception while instantiating ActorLifeCycleListener", (Throwable)e);
            }
        }
    }

    public List<ActorLifecycleListener<?>> getListeners(Class<? extends ElasticActor> actorClass) {
        return this.registry.get(actorClass);
    }
}

