/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.runtime;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.elasticsoftware.elasticactors.runtime.ScannerHelper;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class MessagesScanner {
    private static final Logger logger = LoggerFactory.getLogger(MessagesScanner.class);
    private final ApplicationContext applicationContext;

    public MessagesScanner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        logger.info("Scanning @Message-annotated classes");
        String[] basePackages = ScannerHelper.findBasePackagesOnClasspath(this.applicationContext.getClassLoader(), new String[0]);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        logger.debug("Scanning the following base packages: {}", (Object)basePackages);
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            configurationBuilder.addUrls(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[0]));
            ++n2;
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set messageClasses = reflections.getTypesAnnotatedWith(Message.class);
        logger.info("Found {} classes annotated with @Message", (Object)messageClasses.size());
        if (logger.isDebugEnabled()) {
            logger.debug("Found the following classes annotated with @Message: {}", messageClasses.stream().map(Class::getName).collect(Collectors.toList()));
        }
        for (Class messageClass : messageClasses) {
            Message messageAnnotation = messageClass.getAnnotation(Message.class);
            Class frameworkClass = messageAnnotation.serializationFramework();
            logger.debug("Registering message of type [{}] on [{}]", (Object)messageClass.getName(), (Object)frameworkClass.getName());
            SerializationFramework serializationFramework = (SerializationFramework)this.applicationContext.getBean(frameworkClass);
            serializationFramework.register(messageClass);
        }
    }
}

