/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.runtime;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.elasticsoftware.elasticactors.MessageHandlersRegistry;
import org.elasticsoftware.elasticactors.MethodActor;
import org.elasticsoftware.elasticactors.PluggableMessageHandlers;
import org.elasticsoftware.elasticactors.runtime.ScannerHelper;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class PluggableMessageHandlersScanner
implements MessageHandlersRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PluggableMessageHandlersScanner.class);
    private final ApplicationContext applicationContext;
    private final ListMultimap<Class<? extends MethodActor>, Class<?>> registry = LinkedListMultimap.create();

    public PluggableMessageHandlersScanner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public synchronized void init() {
        logger.info("Scanning @PluggableMessageHandlers-annotated classes");
        String[] basePackages = ScannerHelper.findBasePackagesOnClasspath(this.applicationContext.getClassLoader(), new String[0]);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        logger.debug("Scanning the following base packages: {}", (Object)basePackages);
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            configurationBuilder.addUrls(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[0]));
            ++n2;
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set handlerClasses = reflections.getTypesAnnotatedWith(PluggableMessageHandlers.class);
        logger.info("Found {} classes annotated with @PluggableMessageHandlers", (Object)handlerClasses.size());
        if (logger.isDebugEnabled()) {
            logger.debug("Found the following classes annotated with @PluggableMessageHandlers: {}", handlerClasses.stream().map(Class::getName).collect(Collectors.toList()));
        }
        for (Class handlerClass : handlerClasses) {
            PluggableMessageHandlers handlerAnnotation = handlerClass.getAnnotation(PluggableMessageHandlers.class);
            logger.debug("Registering @PluggableMessageHandlers class [{}] for Method Actor class [{}]", (Object)handlerClass.getName(), (Object)handlerAnnotation.value().getName());
            this.registry.put((Object)handlerAnnotation.value(), (Object)handlerClass);
        }
    }

    public List<Class<?>> getMessageHandlers(Class<? extends MethodActor> methodActor) {
        return this.registry.get(methodActor);
    }
}

