/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScannerHelper {
    private static final Logger logger = LoggerFactory.getLogger(ScannerHelper.class);
    public static final String RESOURCE_NAME = "META-INF/elasticactors.properties";

    public static String[] findBasePackagesOnClasspath(String ... defaultPackages) {
        return ScannerHelper.findBasePackagesOnClasspath(Thread.currentThread().getContextClassLoader(), defaultPackages);
    }

    public static String[] findBasePackagesOnClasspath(ClassLoader classLoader, String ... defaultPackages) {
        HashSet<String> basePackages = new HashSet<String>(Arrays.asList(defaultPackages));
        try {
            Enumeration<URL> resources = classLoader.getResources(RESOURCE_NAME);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties props = new Properties();
                props.load(url.openStream());
                basePackages.add(props.getProperty("basePackage"));
            }
        }
        catch (IOException e) {
            logger.warn("Failed to load elasticactors.properties", (Throwable)e);
        }
        return basePackages.toArray(new String[0]);
    }
}

