/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.spring;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

public class AnnotationConfigApplicationContext
extends GenericApplicationContext {
    private final AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)this);
    private final ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this);

    public AnnotationConfigApplicationContext() {
    }

    public AnnotationConfigApplicationContext(Class<?> ... annotatedClasses) {
        this();
        this.register(annotatedClasses);
        this.refresh();
    }

    public AnnotationConfigApplicationContext(String ... basePackages) {
        this();
        this.scan(basePackages);
        this.refresh();
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        super.setEnvironment(environment);
        this.reader.setEnvironment((Environment)environment);
        this.scanner.setEnvironment((Environment)environment);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.reader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
        this.getBeanFactory().registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", (Object)beanNameGenerator);
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.reader.setScopeMetadataResolver(scopeMetadataResolver);
        this.scanner.setScopeMetadataResolver(scopeMetadataResolver);
    }

    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, (String)"At least one annotated class must be specified");
        this.reader.register((Class[])annotatedClasses);
    }

    public void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        this.scanner.scan(basePackages);
    }

    public void addIncludeFilters(TypeFilter ... typeFilters) {
        TypeFilter[] typeFilterArray = typeFilters;
        int n = typeFilters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeFilter typeFilter = typeFilterArray[n2];
            this.scanner.addIncludeFilter(typeFilter);
            ++n2;
        }
    }

    public void addExcludeFilters(TypeFilter ... typeFilters) {
        TypeFilter[] typeFilterArray = typeFilters;
        int n = typeFilters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeFilter typeFilter = typeFilterArray[n2];
            this.scanner.addExcludeFilter(typeFilter);
            ++n2;
        }
    }

    protected void prepareRefresh() {
        this.scanner.clearCache();
        super.prepareRefresh();
    }
}

