/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors;

public final class ShardKey
implements Comparable<ShardKey> {
    private final String actorSystemName;
    private final int shardId;
    private final String spec;

    public ShardKey(String actorSystemName, int shardId) {
        this.actorSystemName = actorSystemName;
        this.shardId = shardId;
        this.spec = actorSystemName + "/shards/" + shardId;
    }

    public int getShardId() {
        return this.shardId;
    }

    public String getActorSystemName() {
        return this.actorSystemName;
    }

    public String toString() {
        return this.spec;
    }

    public static ShardKey fromString(String shardKey) {
        int separator = shardKey.lastIndexOf("/shards/");
        if (separator < 0) {
            throw new IllegalArgumentException("Missing /shards/ separator");
        }
        String[] components = shardKey.split("/");
        return new ShardKey(components[0], Integer.parseInt(components[2]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShardKey)) {
            return false;
        }
        ShardKey that = (ShardKey)o;
        return this.shardId == that.shardId && this.actorSystemName.equals(that.actorSystemName);
    }

    public int hashCode() {
        int result = this.actorSystemName.hashCode();
        result = 768 * result + this.shardId;
        return result;
    }

    @Override
    public int compareTo(ShardKey other) {
        int result = this.actorSystemName.compareTo(other.actorSystemName);
        return result != 0 ? result : Integer.compare(this.shardId, other.shardId);
    }
}

