/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.state;

import org.elasticsoftware.elasticactors.ActorRef;

public final class MessageSubscriber {
    private final ActorRef subscriberRef;
    private long leases;

    public MessageSubscriber(ActorRef subscriberRef) {
        this(subscriberRef, 0L);
    }

    public MessageSubscriber(ActorRef subscriberRef, long leases) {
        this.subscriberRef = subscriberRef;
        this.leases = leases;
    }

    public ActorRef getSubscriberRef() {
        return this.subscriberRef;
    }

    public long getLeases() {
        return this.leases;
    }

    public long incrementAndGet(long inc) {
        if (inc == Long.MAX_VALUE) {
            this.leases = Long.MAX_VALUE;
        } else {
            try {
                this.leases = Math.addExact(this.leases, inc);
            }
            catch (ArithmeticException e) {
                this.leases = Long.MAX_VALUE;
            }
        }
        return this.leases;
    }

    public long getAndDecrement() {
        if (this.leases > 0L) {
            --this.leases;
            return this.leases + 1L;
        }
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSubscriber that = (MessageSubscriber)o;
        return this.subscriberRef.equals(that.subscriberRef);
    }

    public int hashCode() {
        return this.subscriberRef.hashCode();
    }
}

