/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors;

public final class NodeKey {
    private final String actorSystemName;
    private final String nodeId;

    public NodeKey(String actorSystemName, String nodeId) {
        this.actorSystemName = actorSystemName;
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getActorSystemName() {
        return this.actorSystemName;
    }

    public String toString() {
        return this.actorSystemName + "/nodes/" + this.nodeId;
    }

    public static NodeKey fromString(String shardKey) {
        int separator = shardKey.lastIndexOf("/nodes/");
        if (separator < 0) {
            throw new IllegalArgumentException("Missing /nodes/ separator");
        }
        String[] components = shardKey.split("/");
        return new NodeKey(components[0], components[2]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeKey)) {
            return false;
        }
        NodeKey that = (NodeKey)o;
        return this.nodeId.equals(that.nodeId) && this.actorSystemName.equals(that.actorSystemName);
    }

    public int hashCode() {
        int result = this.actorSystemName.hashCode();
        result = 31 * result + this.nodeId.hashCode();
        return result;
    }
}

