/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.state;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorContext;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ActorState;
import org.elasticsoftware.elasticactors.ActorSystem;
import org.elasticsoftware.elasticactors.ElasticActor;
import org.elasticsoftware.elasticactors.ManagedActor;
import org.elasticsoftware.elasticactors.PersistentSubscription;
import org.elasticsoftware.elasticactors.SingletonActor;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.reactivestreams.InternalPersistentSubscription;
import org.elasticsoftware.elasticactors.reactivestreams.ProcessorContext;
import org.elasticsoftware.elasticactors.state.MessageSubscriber;
import org.reactivestreams.Subscription;

public final class PersistentActor<K>
implements ActorContext,
ProcessorContext {
    private final K key;
    private final InternalActorSystem actorSystem;
    private final transient String currentActorStateVersion;
    private final String previousActorSystemVersion;
    private final Class<? extends ElasticActor> actorClass;
    private final ActorRef ref;
    @Nullable
    private final String affinityKey;
    private volatile transient byte[] serializedState;
    private volatile ActorState actorState;
    private HashMultimap<String, MessageSubscriber> messageSubscribers;
    private List<InternalPersistentSubscription> persistentSubscriptions;

    public PersistentActor(K key, InternalActorSystem actorSystem, String previousActorStateVersion, ActorRef ref, Class<? extends ElasticActor> actorClass, ActorState actorState) {
        this(key, actorSystem, previousActorStateVersion, previousActorStateVersion, actorClass, ref, null, null, actorState, null, null);
    }

    public PersistentActor(K key, InternalActorSystem actorSystem, String previousActorStateVersion, ActorRef ref, String affinityKey, Class<? extends ElasticActor> actorClass, ActorState actorState) {
        this(key, actorSystem, previousActorStateVersion, previousActorStateVersion, actorClass, ref, affinityKey, null, actorState, null, null);
    }

    public PersistentActor(K key, InternalActorSystem actorSystem, String currentActorStateVersion, String previousActorSystemVersion, ActorRef ref, Class<? extends ElasticActor> actorClass, byte[] serializedState, HashMultimap<String, MessageSubscriber> messageSubscribers, List<InternalPersistentSubscription> persistentSubscriptions) {
        this(key, actorSystem, currentActorStateVersion, previousActorSystemVersion, actorClass, ref, null, serializedState, null, messageSubscribers, persistentSubscriptions);
    }

    public PersistentActor(K key, InternalActorSystem actorSystem, String currentActorStateVersion, String previousActorSystemVersion, ActorRef ref, Class<? extends ElasticActor> actorClass, byte[] serializedState, String affinityKey, HashMultimap<String, MessageSubscriber> messageSubscribers, List<InternalPersistentSubscription> persistentSubscriptions) {
        this(key, actorSystem, currentActorStateVersion, previousActorSystemVersion, actorClass, ref, affinityKey, serializedState, null, messageSubscribers, persistentSubscriptions);
    }

    private PersistentActor(K key, InternalActorSystem actorSystem, String currentActorStateVersion, String previousActorSystemVersion, Class<? extends ElasticActor> actorClass, ActorRef ref, @Nullable String affinityKey, byte[] serializedState, ActorState actorState, HashMultimap<String, MessageSubscriber> messageSubscribers, List<InternalPersistentSubscription> persistentSubscriptions) {
        if (actorClass != null) {
            SingletonActor singletonActor = actorClass.getAnnotation(SingletonActor.class);
            if (singletonActor != null && !singletonActor.value().equals(ref.getActorId())) {
                throw new IllegalArgumentException(String.format("Diverging ID for SingletonActor of type '%s'. Expected: '%s'. Found: '%s'", actorClass.getName(), singletonActor.value(), ref.getActorId()));
            }
            ManagedActor managedActor = actorClass.getAnnotation(ManagedActor.class);
            if (managedActor != null && managedActor.exclusive() && !Arrays.asList(managedActor.value()).contains(ref.getActorId())) {
                throw new IllegalArgumentException(String.format("Diverging ID for SingletonActor of type '%s'. Expected one of: %s. Found: '%s'", actorClass.getName(), Arrays.toString(managedActor.value()), ref.getActorId()));
            }
        }
        this.key = key;
        this.actorSystem = actorSystem;
        this.currentActorStateVersion = currentActorStateVersion;
        this.previousActorSystemVersion = previousActorSystemVersion;
        this.actorClass = actorClass;
        this.ref = ref;
        this.affinityKey = affinityKey;
        this.serializedState = serializedState;
        this.actorState = actorState;
        this.messageSubscribers = messageSubscribers;
        this.persistentSubscriptions = persistentSubscriptions;
    }

    public K getKey() {
        return this.key;
    }

    @Nullable
    public String getAffinityKey() {
        return this.affinityKey;
    }

    public String getCurrentActorStateVersion() {
        return this.currentActorStateVersion;
    }

    public String getPreviousActorStateVersion() {
        return this.previousActorSystemVersion;
    }

    public Class<? extends ElasticActor> getActorClass() {
        return this.actorClass;
    }

    public ActorRef getSelf() {
        return this.ref;
    }

    @Nullable
    public Class<?> getSelfType() {
        return this.actorClass;
    }

    public <T extends ActorState> T getState(Class<T> stateClass) {
        return (T)((ActorState)stateClass.cast(this.actorState));
    }

    public ActorState getState() {
        return this.actorState;
    }

    public byte[] getSerializedState() {
        return this.serializedState;
    }

    public void setSerializedState(byte[] serializedState) {
        this.serializedState = serializedState;
    }

    public void setState(ActorState state) {
        this.actorState = state;
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public Collection<PersistentSubscription> getSubscriptions() {
        return this.persistentSubscriptions != null ? ImmutableList.copyOf(this.persistentSubscriptions) : Collections.emptyList();
    }

    public Map<String, Set<ActorRef>> getSubscribers() {
        if (this.messageSubscribers == null || this.messageSubscribers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<ActorRef>> result = new HashMap<String, Set<ActorRef>>();
        this.messageSubscribers.asMap().forEach((message, subscribers) -> {
            HashSet subscriberSet = new HashSet();
            subscribers.forEach(subscriber -> subscriberSet.add(subscriber.getSubscriberRef()));
            result.put((String)message, subscriberSet);
        });
        return result;
    }

    @Override
    public void addSubscription(InternalPersistentSubscription persistentSubscription) {
        if (this.persistentSubscriptions == null) {
            this.persistentSubscriptions = new ArrayList<InternalPersistentSubscription>();
        }
        this.persistentSubscriptions.add(persistentSubscription);
    }

    public Optional<InternalPersistentSubscription> getSubscription(String messageName, ActorRef publisherRef) {
        if (this.persistentSubscriptions != null) {
            return this.persistentSubscriptions.stream().filter(p -> p.getMessageName().equals(messageName) && p.getPublisherRef().equals(publisherRef)).findFirst();
        }
        return Optional.empty();
    }

    public boolean removeSubscription(String messageName, ActorRef publisherRef) {
        return this.persistentSubscriptions != null && this.persistentSubscriptions.removeIf(next -> next.getMessageName().equals(messageName) && next.getPublisherRef().equals(publisherRef));
    }

    public void cancelSubscription(String messageName, ActorRef publisherRef) {
        if (this.persistentSubscriptions != null) {
            this.persistentSubscriptions.stream().filter(p -> p.getMessageName().equals(messageName) && p.getPublisherRef().equals(publisherRef)).findFirst().ifPresent(Subscription::cancel);
        }
    }

    public void cancelAllSubscriptions() {
        if (this.persistentSubscriptions != null) {
            this.persistentSubscriptions.forEach(Subscription::cancel);
        }
    }

    public List<InternalPersistentSubscription> getPersistentSubscriptions() {
        return this.persistentSubscriptions;
    }

    public void addSubscriber(String messageName, MessageSubscriber messageSubscriber) {
        if (this.messageSubscribers == null) {
            this.messageSubscribers = HashMultimap.create();
        }
        this.messageSubscribers.put((Object)messageName, (Object)messageSubscriber);
    }

    public boolean removeSubscriber(String messageName, MessageSubscriber messageSubscriber) {
        return this.messageSubscribers != null && this.messageSubscribers.remove((Object)messageName, (Object)messageSubscriber);
    }

    public HashMultimap<String, MessageSubscriber> getMessageSubscribers() {
        return this.messageSubscribers;
    }

    public void serializeState() throws IOException {
        this.serializedState = (byte[])this.actorSystem.getParent().getSerializationFramework(this.actorState.getSerializationFramework()).getActorStateSerializer(this.actorState).serialize((Object)this.actorState);
    }

    public String toString() {
        return new StringJoiner(", ", PersistentActor.class.getSimpleName() + "{", "}").add("actorClass='" + this.actorClass.getName() + "'").add("ref='" + this.ref + "'").toString();
    }
}

