/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.service;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.LogContextProcessor;
import org.elasticsoftware.elasticactors.tracing.MessageHandlingContext;
import org.elasticsoftware.elasticactors.tracing.MessagingContextManager;
import org.elasticsoftware.elasticactors.tracing.TraceContext;
import org.elasticsoftware.elasticactors.tracing.TracingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class Slf4jLogContextProcessor
implements LogContextProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Slf4jLogContextProcessor.class);

    public void process(@Nullable MessagingContextManager.MessagingScope current, @Nullable MessagingContextManager.MessagingScope next) {
        TraceContext currentTraceContext = null;
        CreationContext currentCreationContext = null;
        MessageHandlingContext currentMessagingContext = null;
        Method currentMethod = null;
        TraceContext nextTraceContext = null;
        CreationContext nextCreationContext = null;
        MessageHandlingContext nextMessagingContext = null;
        Method nextMethod = null;
        if (current != null) {
            currentTraceContext = current.getTraceContext();
            currentCreationContext = current.getCreationContext();
            currentMessagingContext = current.getMessageHandlingContext();
            currentMethod = current.getMethod();
        }
        if (next != null) {
            nextTraceContext = next.getTraceContext();
            nextCreationContext = next.getCreationContext();
            nextMessagingContext = next.getMessageHandlingContext();
            nextMethod = next.getMethod();
        }
        if (currentTraceContext != nextTraceContext) {
            Slf4jLogContextProcessor.fillContext(currentTraceContext, nextTraceContext);
        }
        if (currentCreationContext != nextCreationContext) {
            Slf4jLogContextProcessor.fillContext(currentCreationContext, nextCreationContext);
        }
        if (currentMessagingContext != nextMessagingContext) {
            Slf4jLogContextProcessor.fillContext(currentMessagingContext, nextMessagingContext);
        }
        if (currentMethod != nextMethod) {
            Slf4jLogContextProcessor.fillContext(nextMethod);
        }
    }

    public boolean isLogContextProcessingEnabled() {
        return true;
    }

    private static void fillContext(@Nullable TraceContext current, @Nullable TraceContext next) {
        Slf4jLogContextProcessor.updateBaggage(current, next);
        Slf4jLogContextProcessor.addToLogContext("spanId", current, next, TraceContext::getSpanId);
        Slf4jLogContextProcessor.addToLogContext("traceId", current, next, TraceContext::getTraceId);
        Slf4jLogContextProcessor.addToLogContext("parentId", current, next, TraceContext::getParentId);
    }

    private static void updateBaggage(TraceContext current, TraceContext next) {
        try {
            Map nextBaggage;
            Map oldBaggage = current != null ? current.getBaggage() : null;
            Map map = nextBaggage = next != null ? next.getBaggage() : null;
            if (oldBaggage == nextBaggage) {
                return;
            }
            if (oldBaggage == null) {
                nextBaggage.forEach(Slf4jLogContextProcessor::putOnMDC);
            } else if (nextBaggage == null) {
                oldBaggage.keySet().forEach(key -> Slf4jLogContextProcessor.putOnMDC(key, null));
            } else {
                oldBaggage.forEach((key, value) -> {
                    String nextValue = (String)nextBaggage.get(key);
                    if (!Objects.equals(value, nextValue)) {
                        Slf4jLogContextProcessor.putOnMDC(key, nextValue);
                    }
                });
                nextBaggage.forEach((key, value) -> {
                    String oldValue = (String)oldBaggage.get(key);
                    if (oldValue != null) {
                        return;
                    }
                    if (value != null) {
                        Slf4jLogContextProcessor.putOnMDC(key, value);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("Could not add trace baggage to the MDC. Baggage fields on the MDC might be corrupted.", (Throwable)e);
        }
    }

    private static void fillContext(@Nullable MessageHandlingContext current, @Nullable MessageHandlingContext next) {
        Slf4jLogContextProcessor.addToLogContext("messageType", current, next, MessageHandlingContext::getMessageType);
        Slf4jLogContextProcessor.addToLogContext("sender", current, next, MessageHandlingContext::getSender);
        Slf4jLogContextProcessor.addToLogContext("receiver", current, next, MessageHandlingContext::getReceiver);
        Slf4jLogContextProcessor.addToLogContext("receiverType", current, next, MessageHandlingContext::getReceiverType);
    }

    private static void fillContext(@Nullable CreationContext current, @Nullable CreationContext next) {
        Slf4jLogContextProcessor.addToLogContext("creator", current, next, CreationContext::getCreator);
        Slf4jLogContextProcessor.addToLogContext("creatorType", current, next, CreationContext::getCreatorType);
        Slf4jLogContextProcessor.addToLogContext("creatorMethod", current, next, CreationContext::getCreatorMethod);
        Slf4jLogContextProcessor.addToLogContext("scheduled", current, next, CreationContext::getScheduled);
    }

    private static void fillContext(@Nullable Method next) {
        Slf4jLogContextProcessor.putOnMDC("receiverMethod", Slf4jLogContextProcessor.getValue(next, TracingUtils::shorten));
    }

    private static <D, T> void addToLogContext(@Nonnull String key, @Nullable D oldObject, @Nullable D newObject, @Nonnull Function<D, T> getterFunction) {
        String newValue;
        String oldValue = Slf4jLogContextProcessor.getValue(oldObject, getterFunction);
        if (!Objects.equals(oldValue, newValue = Slf4jLogContextProcessor.getValue(newObject, getterFunction))) {
            Slf4jLogContextProcessor.putOnMDC(key, newValue);
        }
    }

    private static void putOnMDC(@Nonnull String key, String newValue) {
        if (newValue != null) {
            MDC.put((String)key, (String)newValue);
        } else {
            MDC.remove((String)key);
        }
    }

    private static <D, T> String getValue(@Nullable D oldObject, @Nonnull Function<D, T> getterFunction) {
        return oldObject != null ? TracingUtils.safeToString(getterFunction.apply(oldObject)) : null;
    }
}

