/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.configuration;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsoftware.elasticactors.tracing.configuration.ExecutorMethodInterceptor;
import org.elasticsoftware.elasticactors.tracing.configuration.LazyTraceAsyncTaskExecutor;
import org.elasticsoftware.elasticactors.tracing.configuration.LazyTraceExecutor;
import org.elasticsoftware.elasticactors.tracing.configuration.LazyTraceScheduledThreadPoolExecutor;
import org.elasticsoftware.elasticactors.tracing.configuration.LazyTraceThreadPoolTaskExecutor;
import org.elasticsoftware.elasticactors.tracing.configuration.LazyTraceThreadPoolTaskScheduler;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceableExecutorService;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceableScheduledExecutorService;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ReflectionUtils;

class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(ExecutorBeanPostProcessor.class);

    ExecutorBeanPostProcessor() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof LazyTraceThreadPoolTaskExecutor || bean instanceof TraceableScheduledExecutorService || bean instanceof TraceableExecutorService || bean instanceof LazyTraceAsyncTaskExecutor || bean instanceof LazyTraceExecutor) {
            log.info((Object)("Bean is already instrumented " + beanName));
            return bean;
        }
        if (bean instanceof ThreadPoolTaskExecutor) {
            return this.wrapThreadPoolTaskExecutor(bean);
        }
        if (bean instanceof ScheduledExecutorService) {
            return this.wrapScheduledExecutorService(bean);
        }
        if (bean instanceof ExecutorService) {
            return this.wrapExecutorService(bean);
        }
        if (bean instanceof AsyncTaskExecutor) {
            return this.wrapAsyncTaskExecutor(bean);
        }
        if (bean instanceof Executor) {
            return this.wrapExecutor(bean);
        }
        return bean;
    }

    private Object wrapExecutor(Object bean) {
        Executor executor = (Executor)bean;
        boolean methodFinal = ExecutorBeanPostProcessor.anyFinalMethods(executor, Executor.class);
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !methodFinal && !classFinal;
        try {
            return this.createProxy(bean, cglibProxy, (Advice)new ExecutorMethodInterceptor<Executor>(executor));
        }
        catch (AopConfigException ex) {
            if (cglibProxy) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception occurred while trying to create a proxy, falling back to JDK proxy", (Throwable)ex);
                }
                return this.createProxy(bean, false, (Advice)new ExecutorMethodInterceptor<Executor>(executor));
            }
            throw ex;
        }
    }

    private Object wrapThreadPoolTaskExecutor(Object bean) {
        ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodsFinal = ExecutorBeanPostProcessor.anyFinalMethods(executor, ThreadPoolTaskExecutor.class);
        boolean cglibProxy = !classFinal && !methodsFinal;
        return this.createThreadPoolTaskExecutorProxy(bean, cglibProxy, executor);
    }

    private Object wrapExecutorService(Object bean) {
        ExecutorService executor = (ExecutorService)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodFinal = ExecutorBeanPostProcessor.anyFinalMethods(executor, ExecutorService.class);
        boolean cglibProxy = !classFinal && !methodFinal;
        return this.createExecutorServiceProxy(bean, cglibProxy, executor);
    }

    private Object wrapScheduledExecutorService(Object bean) {
        ScheduledExecutorService executor = (ScheduledExecutorService)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodFinal = ExecutorBeanPostProcessor.anyFinalMethods(executor, ExecutorService.class);
        boolean cglibProxy = !classFinal && !methodFinal;
        return this.createScheduledExecutorServiceProxy(bean, cglibProxy, executor);
    }

    private Object wrapAsyncTaskExecutor(Object bean) {
        AsyncTaskExecutor executor = (AsyncTaskExecutor)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodsFinal = ExecutorBeanPostProcessor.anyFinalMethods(executor, AsyncTaskExecutor.class);
        boolean cglibProxy = !classFinal && !methodsFinal;
        return this.createAsyncTaskExecutorProxy(bean, cglibProxy, executor);
    }

    Object createThreadPoolTaskExecutorProxy(Object bean, boolean cglibProxy, ThreadPoolTaskExecutor executor) {
        if (!cglibProxy) {
            return new LazyTraceThreadPoolTaskExecutor(executor);
        }
        return this.getProxiedObject(bean, cglibProxy, (Executor)executor, () -> new LazyTraceThreadPoolTaskExecutor(executor));
    }

    Supplier<Executor> createThreadPoolTaskSchedulerProxy(ThreadPoolTaskScheduler executor) {
        return () -> new LazyTraceThreadPoolTaskScheduler(executor);
    }

    Supplier<Executor> createScheduledThreadPoolExecutorProxy(ScheduledThreadPoolExecutor executor) {
        return () -> new LazyTraceScheduledThreadPoolExecutor(executor.getCorePoolSize(), executor.getThreadFactory(), executor.getRejectedExecutionHandler(), executor);
    }

    Object createExecutorServiceProxy(Object bean, boolean cglibProxy, ExecutorService executor) {
        return this.getProxiedObject(bean, cglibProxy, executor, () -> {
            if (executor instanceof ScheduledExecutorService) {
                return new TraceableScheduledExecutorService(executor);
            }
            return new TraceableExecutorService(executor);
        });
    }

    Object createScheduledExecutorServiceProxy(Object bean, boolean cglibProxy, ScheduledExecutorService executor) {
        return this.getProxiedObject(bean, cglibProxy, executor, () -> new TraceableScheduledExecutorService(executor));
    }

    Object createAsyncTaskExecutorProxy(Object bean, boolean cglibProxy, AsyncTaskExecutor executor) {
        return this.getProxiedObject(bean, cglibProxy, (Executor)executor, () -> {
            if (bean instanceof ThreadPoolTaskScheduler) {
                return new LazyTraceThreadPoolTaskScheduler((ThreadPoolTaskScheduler)executor);
            }
            return new LazyTraceAsyncTaskExecutor(executor);
        });
    }

    private Object getProxiedObject(Object bean, boolean cglibProxy, Executor executor, Supplier<Executor> supplier) {
        ProxyFactoryBean factory = this.proxyFactoryBean(bean, cglibProxy, executor, supplier);
        try {
            return this.getObject(factory);
        }
        catch (Exception ex) {
            block9: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception occurred while trying to get a proxy. Will fallback to a different implementation", (Throwable)ex);
                }
                try {
                    if (bean instanceof ThreadPoolTaskScheduler) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Will wrap ThreadPoolTaskScheduler in its tracing representation due to previous errors");
                        }
                        return this.createThreadPoolTaskSchedulerProxy((ThreadPoolTaskScheduler)bean).get();
                    }
                    if (bean instanceof ScheduledThreadPoolExecutor) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Will wrap ScheduledThreadPoolExecutor in its tracing representation due to previous errors");
                        }
                        return this.createScheduledThreadPoolExecutorProxy((ScheduledThreadPoolExecutor)bean).get();
                    }
                }
                catch (Exception ex2) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"Fallback for special wrappers failed, will try the tracing representation instead", (Throwable)ex2);
                }
            }
            return supplier.get();
        }
    }

    private ProxyFactoryBean proxyFactoryBean(Object bean, boolean cglibProxy, Executor executor, final Supplier<Executor> supplier) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice((Advice)new ExecutorMethodInterceptor<Executor>(executor){

            @Override
            Executor executor(Executor executor) {
                return (Executor)supplier.get();
            }
        });
        factory.setTarget(bean);
        return factory;
    }

    Object getObject(ProxyFactoryBean factory) {
        return factory.getObject();
    }

    Object createProxy(Object bean, boolean cglibProxy, Advice advice) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice(advice);
        factory.setTarget(bean);
        return this.getObject(factory);
    }

    private static <T> boolean anyFinalMethods(T object, Class<T> iface) {
        try {
            for (Method method : ReflectionUtils.getDeclaredMethods(iface)) {
                Method m = ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
                if (m == null || !Modifier.isFinal(m.getModifiers())) continue;
                return true;
            }
        }
        catch (IllegalAccessError er) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while trying to access methods", (Throwable)er);
            }
            return false;
        }
        return false;
    }
}

