/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.elasticsoftware.elasticactors.tracing.configuration.LazyTraceExecutor;
import org.springframework.util.ReflectionUtils;

class ExecutorMethodInterceptor<T extends Executor>
implements MethodInterceptor {
    private final T delegate;

    ExecutorMethodInterceptor(T delegate) {
        this.delegate = delegate;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        T executor = this.executor(this.delegate);
        Method methodOnTracedBean = this.getMethod(invocation, executor);
        if (methodOnTracedBean != null) {
            try {
                return methodOnTracedBean.invoke(executor, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                throw cause != null ? cause : ex;
            }
        }
        return invocation.proceed();
    }

    private Method getMethod(MethodInvocation invocation, Object object) {
        Method method = invocation.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }

    T executor(T executor) {
        return (T)new LazyTraceExecutor((Executor)executor);
    }
}

