/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.configuration;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.elasticsoftware.elasticactors.tracing.configuration.LazyTraceScheduledThreadPoolExecutor;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceCallable;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceRunnable;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceableExecutorService;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceableScheduledExecutorService;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.ErrorHandler;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.concurrent.ListenableFuture;

class LazyTraceThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler {
    private final ThreadPoolTaskScheduler delegate;
    private final Method initializeExecutor;
    private final Method createExecutor;
    private final Method cancelRemainingTask;
    private final Method nextThreadName;
    private final Method getDefaultThreadNamePrefix;

    LazyTraceThreadPoolTaskScheduler(ThreadPoolTaskScheduler delegate) {
        this.delegate = delegate;
        this.initializeExecutor = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"initializeExecutor", null);
        this.makeAccessibleIfNotNull(this.initializeExecutor);
        this.createExecutor = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"createExecutor", null);
        this.makeAccessibleIfNotNull(this.createExecutor);
        this.cancelRemainingTask = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"cancelRemainingTask", null);
        this.makeAccessibleIfNotNull(this.cancelRemainingTask);
        this.nextThreadName = ReflectionUtils.findMethod(ThreadPoolTaskScheduler.class, (String)"nextThreadName", null);
        this.makeAccessibleIfNotNull(this.nextThreadName);
        this.getDefaultThreadNamePrefix = ReflectionUtils.findMethod(CustomizableThreadCreator.class, (String)"getDefaultThreadNamePrefix", null);
        this.makeAccessibleIfNotNull(this.getDefaultThreadNamePrefix);
    }

    private void makeAccessibleIfNotNull(Method method) {
        if (method != null) {
            ReflectionUtils.makeAccessible((Method)method);
        }
    }

    public void setPoolSize(int poolSize) {
        this.delegate.setPoolSize(poolSize);
    }

    public void setRemoveOnCancelPolicy(boolean removeOnCancelPolicy) {
        this.delegate.setRemoveOnCancelPolicy(removeOnCancelPolicy);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.delegate.setErrorHandler(errorHandler);
    }

    public ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        ExecutorService executorService = (ExecutorService)ReflectionUtils.invokeMethod((Method)this.initializeExecutor, (Object)this.delegate, (Object[])new Object[]{this.traceThreadFactory(threadFactory), rejectedExecutionHandler});
        if (executorService instanceof TraceableScheduledExecutorService) {
            return executorService;
        }
        return new TraceableExecutorService(executorService);
    }

    private ThreadFactory traceThreadFactory(ThreadFactory threadFactory) {
        return r -> threadFactory.newThread(TraceRunnable.wrap(r));
    }

    public ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        ScheduledExecutorService executorService = (ScheduledExecutorService)ReflectionUtils.invokeMethod((Method)this.createExecutor, (Object)this.delegate, (Object[])new Object[]{poolSize, this.traceThreadFactory(threadFactory), rejectedExecutionHandler});
        if (executorService instanceof TraceableScheduledExecutorService) {
            return executorService;
        }
        return new TraceableScheduledExecutorService(executorService);
    }

    public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
        ScheduledExecutorService executor = this.delegate.getScheduledExecutor();
        return executor instanceof TraceableScheduledExecutorService ? executor : new TraceableScheduledExecutorService(executor);
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() throws IllegalStateException {
        ScheduledThreadPoolExecutor executor = this.delegate.getScheduledThreadPoolExecutor();
        if (executor instanceof LazyTraceScheduledThreadPoolExecutor) {
            return executor;
        }
        return new LazyTraceScheduledThreadPoolExecutor(executor.getCorePoolSize(), executor.getThreadFactory(), executor.getRejectedExecutionHandler(), executor);
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public boolean isRemoveOnCancelPolicy() {
        return this.delegate.isRemoveOnCancelPolicy();
    }

    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    public void execute(Runnable task) {
        this.delegate.execute((Runnable)TraceRunnable.wrap(task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute((Runnable)TraceRunnable.wrap(task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit((Runnable)TraceRunnable.wrap(task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(TraceCallable.wrap(task));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable((Runnable)TraceRunnable.wrap(task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable(TraceCallable.wrap(task));
    }

    public void cancelRemainingTask(Runnable task) {
        ReflectionUtils.invokeMethod((Method)this.cancelRemainingTask, (Object)this.delegate, (Object[])new Object[]{TraceRunnable.wrap(task)});
    }

    public boolean prefersShortLivedTasks() {
        return this.delegate.prefersShortLivedTasks();
    }

    @Nullable
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.delegate.schedule((Runnable)TraceRunnable.wrap(task), trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.delegate.schedule((Runnable)TraceRunnable.wrap(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.delegate.scheduleAtFixedRate((Runnable)TraceRunnable.wrap(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.delegate.scheduleAtFixedRate((Runnable)TraceRunnable.wrap(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)TraceRunnable.wrap(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)TraceRunnable.wrap(task), delay);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.delegate.setThreadFactory(threadFactory);
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.delegate.setThreadNamePrefix(threadNamePrefix);
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.delegate.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.delegate.setWaitForTasksToCompleteOnShutdown(waitForJobsToCompleteOnShutdown);
    }

    public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
        this.delegate.setAwaitTerminationSeconds(awaitTerminationSeconds);
    }

    public void setBeanName(String name) {
        this.delegate.setBeanName(name);
    }

    public void afterPropertiesSet() {
        this.delegate.afterPropertiesSet();
    }

    public void initialize() {
        this.delegate.initialize();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public Thread newThread(Runnable runnable) {
        return this.delegate.newThread(runnable);
    }

    public String getThreadNamePrefix() {
        return this.delegate.getThreadNamePrefix();
    }

    public void setThreadPriority(int threadPriority) {
        this.delegate.setThreadPriority(threadPriority);
    }

    public int getThreadPriority() {
        return this.delegate.getThreadPriority();
    }

    public void setDaemon(boolean daemon) {
        this.delegate.setDaemon(daemon);
    }

    public boolean isDaemon() {
        return this.delegate.isDaemon();
    }

    public void setThreadGroupName(String name) {
        this.delegate.setThreadGroupName(name);
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.delegate.setThreadGroup(threadGroup);
    }

    @Nullable
    public ThreadGroup getThreadGroup() {
        return this.delegate.getThreadGroup();
    }

    public Thread createThread(Runnable runnable) {
        return this.delegate.createThread(runnable);
    }

    public String nextThreadName() {
        return (String)ReflectionUtils.invokeMethod((Method)this.nextThreadName, (Object)this.delegate);
    }

    public String getDefaultThreadNamePrefix() {
        if (this.delegate == null) {
            return super.getDefaultThreadNamePrefix();
        }
        return (String)ReflectionUtils.invokeMethod((Method)this.getDefaultThreadNamePrefix, (Object)this.delegate);
    }

    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        return this.delegate.schedule((Runnable)TraceRunnable.wrap(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        return this.delegate.scheduleAtFixedRate((Runnable)TraceRunnable.wrap(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        return this.delegate.scheduleAtFixedRate((Runnable)TraceRunnable.wrap(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)TraceRunnable.wrap(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)TraceRunnable.wrap(task), delay);
    }
}

