/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.configuration;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.MessagingContextManager;
import org.elasticsoftware.elasticactors.tracing.TraceContext;

public class TraceCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final TraceContext parent;
    private final CreationContext creationContext;

    public static <V> TraceCallable<V> wrap(@Nonnull Callable<V> delegate) {
        if (delegate instanceof TraceCallable) {
            return (TraceCallable)delegate;
        }
        return new TraceCallable<V>(delegate);
    }

    private TraceCallable(Callable<V> delegate) {
        this.delegate = delegate;
        MessagingContextManager.MessagingScope scope = MessagingContextManager.getManager().currentScope();
        this.parent = scope != null ? scope.getTraceContext() : null;
        this.creationContext = scope != null ? scope.creationContextFromScope() : null;
    }

    @Override
    public V call() throws Exception {
        try (MessagingContextManager.MessagingScope ignored = MessagingContextManager.getManager().enter(new TraceContext(this.parent), this.creationContext);){
            V v = this.delegate.call();
            return v;
        }
    }
}

