/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.configuration;

import javax.annotation.Nonnull;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.MessagingContextManager;
import org.elasticsoftware.elasticactors.tracing.TraceContext;

public class TraceRunnable
implements Runnable {
    private final Runnable delegate;
    private final TraceContext parent;
    private final CreationContext creationContext;

    public static TraceRunnable wrap(@Nonnull Runnable delegate) {
        if (delegate instanceof TraceRunnable) {
            return (TraceRunnable)delegate;
        }
        return new TraceRunnable(delegate);
    }

    private TraceRunnable(@Nonnull Runnable delegate) {
        this.delegate = delegate;
        MessagingContextManager.MessagingScope scope = MessagingContextManager.getManager().currentScope();
        this.parent = scope != null ? scope.getTraceContext() : null;
        this.creationContext = scope != null ? scope.creationContextFromScope() : null;
    }

    @Override
    public void run() {
        try (MessagingContextManager.MessagingScope ignored = MessagingContextManager.getManager().enter(new TraceContext(this.parent), this.creationContext);){
            this.delegate.run();
        }
    }
}

