/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.configuration;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceCallable;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceRunnable;
import org.elasticsoftware.elasticactors.tracing.configuration.TraceableExecutorService;

public class TraceableScheduledExecutorService
extends TraceableExecutorService
implements ScheduledExecutorService {
    public TraceableScheduledExecutorService(ExecutorService delegate) {
        super(delegate);
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.getScheduledExecutorService().schedule(TraceRunnable.wrap(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.getScheduledExecutorService().schedule(TraceCallable.wrap(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutorService().scheduleAtFixedRate(TraceRunnable.wrap(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.getScheduledExecutorService().scheduleWithFixedDelay(TraceRunnable.wrap(command), initialDelay, delay, unit);
    }
}

