/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.service;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorContext;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.MessageHandlingContext;
import org.elasticsoftware.elasticactors.tracing.MessagingContextManager;
import org.elasticsoftware.elasticactors.tracing.NoopMessagingScope;
import org.elasticsoftware.elasticactors.tracing.TraceContext;
import org.elasticsoftware.elasticactors.tracing.TracedMessage;
import org.elasticsoftware.elasticactors.tracing.TracingUtils;
import org.slf4j.MDC;

public final class TracingMessagingContextManager
extends MessagingContextManager {
    private static final ThreadLocal<Deque<MessagingContextManager.MessagingScope>> scopes = ThreadLocal.withInitial(ArrayDeque::new);

    public boolean isTracingEnabled() {
        return true;
    }

    @Nullable
    public MessagingContextManager.MessagingScope currentScope() {
        return scopes.get().peek();
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nullable ActorContext context, @Nullable TracedMessage message) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(new TraceContext(message != null ? message.getTraceContext() : null), (CreationContext)(message != null ? message.getCreationContext() : (currentScope != null ? currentScope.getCreationContext() : null)), new MessageHandlingContext(context, message), currentScope != null ? currentScope.getMethod() : null);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nullable TraceContext traceContext, @Nullable CreationContext creationContext) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(traceContext, creationContext, currentScope != null ? currentScope.getMessageHandlingContext() : null, currentScope != null ? currentScope.getMethod() : null);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nullable TracedMessage message) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(new TraceContext(message != null ? message.getTraceContext() : null), (CreationContext)(message != null ? message.getCreationContext() : (currentScope != null ? currentScope.getCreationContext() : null)), currentScope != null ? currentScope.getMessageHandlingContext() : null, currentScope != null ? currentScope.getMethod() : null);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nonnull Method context) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(currentScope != null ? currentScope.getTraceContext() : null, currentScope != null ? currentScope.getCreationContext() : null, currentScope != null ? currentScope.getMessageHandlingContext() : null, context);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    private static void enterScope(Deque<MessagingContextManager.MessagingScope> currentStack, MessagingContextManager.MessagingScope currentScope, MessagingContextManager.MessagingScope newScope) {
        logger.debug("Current number of stacked scopes: {}", (Object)currentStack.size());
        logger.debug("Current scope: {}", (Object)currentScope);
        currentStack.push(newScope);
        TracingMessagingContextManager.fillContext(currentScope, newScope);
        logger.debug("Entering new scope: {}", (Object)newScope);
    }

    private static void fillContext(@Nullable MessagingContextManager.MessagingScope current, @Nullable MessagingContextManager.MessagingScope next) {
        TraceContext currentTraceContext = null;
        CreationContext currentCreationContext = null;
        MessageHandlingContext currentMessagingContext = null;
        Method currentMethod = null;
        TraceContext nextTraceContext = null;
        CreationContext nextCreationContext = null;
        MessageHandlingContext nextMessagingContext = null;
        Method nextMethod = null;
        if (current != null) {
            currentTraceContext = current.getTraceContext();
            currentCreationContext = current.getCreationContext();
            currentMessagingContext = current.getMessageHandlingContext();
            currentMethod = current.getMethod();
        }
        if (next != null) {
            nextTraceContext = next.getTraceContext();
            nextCreationContext = next.getCreationContext();
            nextMessagingContext = next.getMessageHandlingContext();
            nextMethod = next.getMethod();
        }
        if (currentTraceContext != nextTraceContext) {
            TracingMessagingContextManager.fillContext(currentTraceContext, nextTraceContext);
        }
        if (currentCreationContext != nextCreationContext) {
            TracingMessagingContextManager.fillContext(currentCreationContext, nextCreationContext);
        }
        if (currentMessagingContext != nextMessagingContext) {
            TracingMessagingContextManager.fillContext(currentMessagingContext, nextMessagingContext);
        }
        if (currentMethod != nextMethod) {
            TracingMessagingContextManager.fillContext(nextMethod);
        }
    }

    private static void fillContext(@Nullable TraceContext current, @Nullable TraceContext next) {
        TracingMessagingContextManager.updateBaggage(current, next);
        TracingMessagingContextManager.addToLogContext("spanId", current, next, TraceContext::getSpanId);
        TracingMessagingContextManager.addToLogContext("traceId", current, next, TraceContext::getTraceId);
        TracingMessagingContextManager.addToLogContext("parentId", current, next, TraceContext::getParentId);
    }

    private static void updateBaggage(TraceContext current, TraceContext next) {
        try {
            Map nextBaggage;
            Map oldBaggage = current != null ? current.getBaggage() : null;
            Map map = nextBaggage = next != null ? next.getBaggage() : null;
            if (oldBaggage == nextBaggage) {
                return;
            }
            if (oldBaggage == null) {
                nextBaggage.forEach(TracingMessagingContextManager::putOnMDC);
            } else if (nextBaggage == null) {
                oldBaggage.keySet().forEach(key -> TracingMessagingContextManager.putOnMDC(key, null));
            } else {
                oldBaggage.forEach((key, value) -> {
                    String nextValue = (String)nextBaggage.get(key);
                    if (!Objects.equals(value, nextValue)) {
                        TracingMessagingContextManager.putOnMDC(key, nextValue);
                    }
                });
                nextBaggage.forEach((key, value) -> {
                    String oldValue = (String)oldBaggage.get(key);
                    if (oldValue != null) {
                        return;
                    }
                    if (value != null) {
                        TracingMessagingContextManager.putOnMDC(key, value);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("Could not add trace baggage to the MDC. Baggage fields on the MDC might be corrupted.", (Throwable)e);
        }
    }

    private static void fillContext(@Nullable MessageHandlingContext current, @Nullable MessageHandlingContext next) {
        TracingMessagingContextManager.addToLogContext("messageType", current, next, MessageHandlingContext::getMessageType);
        TracingMessagingContextManager.addToLogContext("sender", current, next, MessageHandlingContext::getSender);
        TracingMessagingContextManager.addToLogContext("receiver", current, next, MessageHandlingContext::getReceiver);
        TracingMessagingContextManager.addToLogContext("receiverType", current, next, MessageHandlingContext::getReceiverType);
    }

    private static void fillContext(@Nullable CreationContext current, @Nullable CreationContext next) {
        TracingMessagingContextManager.addToLogContext("creator", current, next, CreationContext::getCreator);
        TracingMessagingContextManager.addToLogContext("creatorType", current, next, CreationContext::getCreatorType);
        TracingMessagingContextManager.addToLogContext("creatorMethod", current, next, CreationContext::getCreatorMethod);
        TracingMessagingContextManager.addToLogContext("scheduled", current, next, CreationContext::getScheduled);
    }

    private static void fillContext(@Nullable Method next) {
        TracingMessagingContextManager.putOnMDC("receiverMethod", TracingMessagingContextManager.getValue(next, TracingUtils::shorten));
    }

    private static <D, T> void addToLogContext(@Nonnull String key, @Nullable D oldObject, @Nullable D newObject, @Nonnull Function<D, T> getterFunction) {
        String newValue;
        String oldValue = TracingMessagingContextManager.getValue(oldObject, getterFunction);
        if (!Objects.equals(oldValue, newValue = TracingMessagingContextManager.getValue(newObject, getterFunction))) {
            TracingMessagingContextManager.putOnMDC(key, newValue);
        }
    }

    private static void putOnMDC(@Nonnull String key, String newValue) {
        if (newValue != null) {
            MDC.put((String)key, (String)newValue);
        } else {
            MDC.remove((String)key);
        }
    }

    private static <D, T> String getValue(@Nullable D oldObject, @Nonnull Function<D, T> getterFunction) {
        return oldObject != null ? TracingUtils.safeToString(getterFunction.apply(oldObject)) : null;
    }

    private static final class TracingMessagingScope
    implements MessagingContextManager.MessagingScope {
        private final TraceContext traceContext;
        private final CreationContext creationContext;
        private final MessageHandlingContext messageHandlingContext;
        private final Method method;
        private final AtomicBoolean closed;

        @Nullable
        public TraceContext getTraceContext() {
            return this.traceContext;
        }

        @Nullable
        public CreationContext getCreationContext() {
            return this.creationContext;
        }

        @Nullable
        public CreationContext creationContextFromScope() {
            if (this.messageHandlingContext != null) {
                return new CreationContext(this.messageHandlingContext.getReceiver(), this.messageHandlingContext.getReceiverType(), this.method);
            }
            return this.creationContext;
        }

        @Nullable
        public MessageHandlingContext getMessageHandlingContext() {
            return this.messageHandlingContext;
        }

        @Nullable
        public Method getMethod() {
            return this.method;
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public TracingMessagingScope(@Nullable TraceContext traceContext, @Nullable CreationContext creationContext, @Nullable MessageHandlingContext messageHandlingContext, @Nullable Method method) {
            this.traceContext = traceContext;
            this.creationContext = creationContext;
            this.messageHandlingContext = messageHandlingContext;
            this.method = method;
            this.closed = new AtomicBoolean(false);
        }

        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                logger.debug("Closing scope: {}", (Object)this);
                Deque currentStack = (Deque)scopes.get();
                logger.debug("Current number of stacked scopes: {}", (Object)currentStack.size());
                MessagingContextManager.MessagingScope currentScope = (MessagingContextManager.MessagingScope)currentStack.peek();
                if (currentScope == this) {
                    currentStack.pop();
                    MessagingContextManager.MessagingScope previousScope = (MessagingContextManager.MessagingScope)currentStack.peek();
                    logger.debug("Number of scopes left in the stack: {}", (Object)currentStack.size());
                    logger.debug("Rolling back to scope: {}", (Object)previousScope);
                    TracingMessagingContextManager.fillContext(this, previousScope);
                } else {
                    logger.error("Removing {} from scope, but context in scope was actually {}. Context in scope likely incorrect.", (Object)this, (Object)currentScope);
                }
            } else {
                logger.warn("Trying to close on an already closed scope: {}", (Object)this);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TracingMessagingScope)) {
                return false;
            }
            TracingMessagingScope that = (TracingMessagingScope)o;
            return Objects.equals(this.traceContext, that.traceContext) && Objects.equals(this.creationContext, that.creationContext) && Objects.equals(this.messageHandlingContext, that.messageHandlingContext) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.traceContext, this.creationContext, this.messageHandlingContext, this.method);
        }

        public String toString() {
            return new StringJoiner(", ", TracingMessagingScope.class.getSimpleName() + "{", "}").add("traceContext=" + this.traceContext).add("creationContext=" + this.creationContext).add("messageHandlingContext=" + this.messageHandlingContext).add("method=" + this.method).add("closed=" + this.closed).toString();
        }
    }
}

