/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.tracing.service;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorContext;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.LogContextProcessor;
import org.elasticsoftware.elasticactors.tracing.MessageHandlingContext;
import org.elasticsoftware.elasticactors.tracing.MessagingContextManager;
import org.elasticsoftware.elasticactors.tracing.NoopMessagingScope;
import org.elasticsoftware.elasticactors.tracing.TraceContext;
import org.elasticsoftware.elasticactors.tracing.TracedMessage;

public final class TracingMessagingContextManager
extends MessagingContextManager {
    private static final ThreadLocal<Deque<MessagingContextManager.MessagingScope>> scopes = ThreadLocal.withInitial(ArrayDeque::new);

    public boolean isTracingEnabled() {
        return true;
    }

    @Nullable
    public MessagingContextManager.MessagingScope currentScope() {
        return scopes.get().peek();
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nullable ActorContext context, @Nullable TracedMessage message) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(new TraceContext(message != null ? message.getTraceContext() : null), (CreationContext)(message != null ? message.getCreationContext() : (currentScope != null ? currentScope.getCreationContext() : null)), new MessageHandlingContext(context, message), currentScope != null ? currentScope.getMethod() : null);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nullable TraceContext traceContext, @Nullable CreationContext creationContext) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(traceContext, creationContext, currentScope != null ? currentScope.getMessageHandlingContext() : null, currentScope != null ? currentScope.getMethod() : null);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nullable TracedMessage message) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(new TraceContext(message != null ? message.getTraceContext() : null), (CreationContext)(message != null ? message.getCreationContext() : (currentScope != null ? currentScope.getCreationContext() : null)), currentScope != null ? currentScope.getMessageHandlingContext() : null, currentScope != null ? currentScope.getMethod() : null);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    @Nonnull
    public MessagingContextManager.MessagingScope enter(@Nonnull Method context) {
        try {
            Deque<MessagingContextManager.MessagingScope> currentStack = scopes.get();
            MessagingContextManager.MessagingScope currentScope = currentStack.peek();
            TracingMessagingScope newScope = new TracingMessagingScope(currentScope != null ? currentScope.getTraceContext() : null, currentScope != null ? currentScope.getCreationContext() : null, currentScope != null ? currentScope.getMessageHandlingContext() : null, context);
            TracingMessagingContextManager.enterScope(currentStack, currentScope, newScope);
            return newScope;
        }
        catch (Exception e) {
            logger.error("Exception thrown while creating messaging scope", (Throwable)e);
            return NoopMessagingScope.INSTANCE;
        }
    }

    public boolean isLogContextProcessingEnabled() {
        return LogContextProcessorHolder.INSTANCE.isLogContextProcessingEnabled();
    }

    private static void enterScope(Deque<MessagingContextManager.MessagingScope> currentStack, MessagingContextManager.MessagingScope currentScope, MessagingContextManager.MessagingScope newScope) {
        logger.debug("Current number of stacked scopes: {}", (Object)currentStack.size());
        logger.debug("Current scope: {}", (Object)currentScope);
        currentStack.push(newScope);
        TracingMessagingContextManager.fillContext(currentScope, newScope);
        logger.debug("Entering new scope: {}", (Object)newScope);
    }

    private static void fillContext(@Nullable MessagingContextManager.MessagingScope current, @Nullable MessagingContextManager.MessagingScope next) {
        LogContextProcessorHolder.INSTANCE.process(current, next);
    }

    private static final class NoopLogContextProcessor
    implements LogContextProcessor {
        private NoopLogContextProcessor() {
        }

        public void process(@Nullable MessagingContextManager.MessagingScope current, @Nullable MessagingContextManager.MessagingScope next) {
        }

        public boolean isLogContextProcessingEnabled() {
            return false;
        }
    }

    private static final class TracingMessagingScope
    implements MessagingContextManager.MessagingScope {
        private final TraceContext traceContext;
        private final CreationContext creationContext;
        private final MessageHandlingContext messageHandlingContext;
        private final Method method;
        private final AtomicBoolean closed;

        @Nullable
        public TraceContext getTraceContext() {
            return this.traceContext;
        }

        @Nullable
        public CreationContext getCreationContext() {
            return this.creationContext;
        }

        @Nullable
        public CreationContext creationContextFromScope() {
            if (this.messageHandlingContext != null) {
                return new CreationContext(this.messageHandlingContext.getReceiver(), this.messageHandlingContext.getReceiverType(), this.method);
            }
            return this.creationContext;
        }

        @Nullable
        public MessageHandlingContext getMessageHandlingContext() {
            return this.messageHandlingContext;
        }

        @Nullable
        public Method getMethod() {
            return this.method;
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public TracingMessagingScope(@Nullable TraceContext traceContext, @Nullable CreationContext creationContext, @Nullable MessageHandlingContext messageHandlingContext, @Nullable Method method) {
            this.traceContext = traceContext;
            this.creationContext = creationContext;
            this.messageHandlingContext = messageHandlingContext;
            this.method = method;
            this.closed = new AtomicBoolean(false);
        }

        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                logger.debug("Closing scope: {}", (Object)this);
                Deque currentStack = (Deque)scopes.get();
                logger.debug("Current number of stacked scopes: {}", (Object)currentStack.size());
                MessagingContextManager.MessagingScope currentScope = (MessagingContextManager.MessagingScope)currentStack.peek();
                if (currentScope == this) {
                    currentStack.pop();
                    MessagingContextManager.MessagingScope previousScope = (MessagingContextManager.MessagingScope)currentStack.peek();
                    logger.debug("Number of scopes left in the stack: {}", (Object)currentStack.size());
                    logger.debug("Rolling back to scope: {}", (Object)previousScope);
                    TracingMessagingContextManager.fillContext(this, previousScope);
                } else {
                    logger.error("Removing {} from scope, but context in scope was actually {}. Context in scope likely incorrect.", (Object)this, (Object)currentScope);
                }
            } else {
                logger.warn("Trying to close on an already closed scope: {}", (Object)this);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TracingMessagingScope)) {
                return false;
            }
            TracingMessagingScope that = (TracingMessagingScope)o;
            return Objects.equals(this.traceContext, that.traceContext) && Objects.equals(this.creationContext, that.creationContext) && Objects.equals(this.messageHandlingContext, that.messageHandlingContext) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.traceContext, this.creationContext, this.messageHandlingContext, this.method);
        }

        public String toString() {
            return new StringJoiner(", ", TracingMessagingScope.class.getSimpleName() + "{", "}").add("traceContext=" + this.traceContext).add("creationContext=" + this.creationContext).add("messageHandlingContext=" + this.messageHandlingContext).add("method=" + this.method).add("closed=" + this.closed).toString();
        }
    }

    private static final class LogContextProcessorHolder {
        private static final LogContextProcessor INSTANCE = LogContextProcessorHolder.loadService();

        private LogContextProcessorHolder() {
        }

        private static LogContextProcessor loadService() {
            try {
                return Optional.of(ServiceLoader.load(LogContextProcessor.class)).map(ServiceLoader::iterator).filter(Iterator::hasNext).map(LogContextProcessorHolder::loadFirst).orElseGet(() -> {
                    logger.warn("No implementations of LogContextProcessor were found. Falling back to no-op.");
                    return new NoopLogContextProcessor();
                });
            }
            catch (Exception e) {
                logger.error("Exception thrown while loading LogContextProcessor implementation. Falling back to no-op.", (Throwable)e);
                return new NoopLogContextProcessor();
            }
        }

        private static LogContextProcessor loadFirst(Iterator<LogContextProcessor> iter) {
            LogContextProcessor service = iter.next();
            logger.info("Loaded LogContextProcessor implementation [{}]", (Object)service.getClass().getName());
            return service;
        }
    }
}

