/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.indexing.elasticsearch;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.annotation.PreDestroy;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsoftware.elasticactors.indexing.elasticsearch.indexer.Indexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.aspectj.EnableSpringConfigured;
import org.springframework.core.env.Environment;

@Configuration
@EnableSpringConfigured
public class IndexderAppConfig {
    private static final Logger logger = LoggerFactory.getLogger(IndexderAppConfig.class);
    private TransportClient client;

    @Bean(name={"indexingElasticsearchClient"})
    public Client createElasticsearchClient(Environment environment) {
        Object[] elasticsearchHosts = (String[])environment.getRequiredProperty("ea.indexing.elasticsearch.hosts", String[].class);
        int elasticsearchPort = (Integer)environment.getProperty("ea.indexing.elasticsearch.port", Integer.class, (Object)9300);
        String elasticsearchClusterName = (String)environment.getProperty("ea.indexing.elasticsearch.cluster.name", String.class, (Object)"elasticsearch");
        logger.info("Creating elasticsearch client with hosts <{}>", (Object)Arrays.toString(elasticsearchHosts));
        Settings settings = Settings.builder().put("cluster.name", elasticsearchClusterName).build();
        this.client = new PreBuiltTransportClient(settings, new Class[0]);
        for (Object elasticsearchHost : elasticsearchHosts) {
            try {
                this.client.addTransportAddress(new TransportAddress(InetAddress.getByName((String)elasticsearchHost), elasticsearchPort));
            }
            catch (UnknownHostException e) {
                throw new BeanCreationException("Could not add elasticsearch host <" + (String)elasticsearchHost + "> to client configuration. Aborting", (Throwable)e);
            }
        }
        return this.client;
    }

    @Bean(name={"elasticsearchIndexer"})
    public Indexer createIndexer(Client client) {
        return new Indexer(client);
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            try {
                logger.info("Shutting down elasticsearch client");
                this.client.close();
            }
            catch (Exception e) {
                logger.warn("Exception while trying to shutdown the elasticsearch client", (Throwable)e);
            }
        }
    }
}

