/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.activemq;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.elasticsoftware.elasticactors.MessageDeliveryException;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.MessageQueue;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteMessageQueue
implements MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(RemoteMessageQueue.class);
    private final String queueName;
    private final String routingKey;
    private final ClientSession clientSession;
    private final ClientProducer producer;
    private final AtomicBoolean recovering = new AtomicBoolean(false);

    RemoteMessageQueue(String queueName, String routingKey, ClientSession clientSession, ClientProducer clientProducer) throws ActiveMQException {
        this.queueName = queueName;
        this.routingKey = routingKey;
        this.clientSession = clientSession;
        this.producer = clientProducer;
    }

    public boolean offer(InternalMessage message) {
        if (this.recovering.get()) {
            throw new MessageDeliveryException("MessagingService is recovering", true);
        }
        ClientMessage clientMessage = this.clientSession.createMessage(message.isDurable());
        clientMessage.getBodyBuffer().writeBytes(message.toByteArray());
        clientMessage.putStringProperty("routingKey", this.routingKey);
        clientMessage.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, UUIDTools.toByteArray((UUID)message.getId()));
        if (message.getTimeout() >= 0) {
            clientMessage.setExpiration(System.currentTimeMillis() + (long)message.getTimeout());
        }
        try {
            this.producer.send((Message)clientMessage);
            return true;
        }
        catch (ActiveMQException e) {
            throw new MessageDeliveryException("IOException while publishing message", (Throwable)e, false);
        }
    }

    public boolean add(InternalMessage message) {
        return this.offer(message);
    }

    public InternalMessage poll() {
        return null;
    }

    public String getName() {
        return this.queueName;
    }

    public void initialize() throws Exception {
        logger.info("Starting remote message queue [{}->{}]", (Object)this.routingKey, (Object)this.queueName);
        this.clientSession.start();
    }

    public void destroy() {
        try {
            logger.info("Stopping remote message queue [{}->{}]", (Object)this.routingKey, (Object)this.queueName);
            this.producer.close();
            this.clientSession.close();
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
    }
}

