/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import org.elasticsoftware.elasticactors.activemq.ActiveMQArtemisMessagingService;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactory;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactoryFactory;
import org.elasticsoftware.elasticactors.serialization.SerializationAccessor;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.InternalMessageDeserializer;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public class MessagingConfiguration {
    @Bean(name={"messagingService"})
    public ActiveMQArtemisMessagingService getMessagingService(@Qualifier(value="queueExecutor") ThreadBoundExecutor queueExecutor, InternalActorSystem internalActorSystem, ActorRefFactory actorRefFactory, Environment env) {
        String clusterName = env.getRequiredProperty("ea.cluster");
        String activeMQHosts = env.getRequiredProperty("ea.activemq.hosts");
        String activeMQUsername = env.getProperty("ea.activemq.username", "guest");
        String activeMQPassword = env.getProperty("ea.activemq.password", "guest");
        boolean useMessageHandler = (Boolean)env.getProperty("ea.activemq.useMessageHandler", Boolean.TYPE, (Object)true);
        boolean useReceiveImmediate = (Boolean)env.getProperty("ea.activemq.useReceiveImmediate", Boolean.TYPE, (Object)false);
        return new ActiveMQArtemisMessagingService(activeMQHosts, activeMQUsername, activeMQPassword, clusterName, queueExecutor, new InternalMessageDeserializer(new ActorRefDeserializer(actorRefFactory), (SerializationAccessor)internalActorSystem), useMessageHandler, useReceiveImmediate);
    }

    @Bean(name={"localMessageQueueFactory"})
    public MessageQueueFactory getLocalMessageQueueFactory(ActiveMQArtemisMessagingService messagingService) {
        return messagingService.getLocalMessageQueueFactory();
    }

    @Bean(name={"remoteMessageQueueFactory"})
    public MessageQueueFactory getRemoteMessageQueueFactory(ActiveMQArtemisMessagingService messagingService) {
        return messagingService.getRemoteMessageQueueFactory();
    }

    @Bean(name={"remoteActorSystemMessageQueueFactoryFactory"})
    public MessageQueueFactoryFactory getRemoteActorSystemMessageQueueFactoryFactory(ActiveMQArtemisMessagingService messagingService) {
        return messagingService.getRemoteActorSystemMessageQueueFactoryFactory();
    }
}

