/*
 * Decompiled with CFR 0.152.
 */
package org.encryfoundation.common.utils;

import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bouncycastle.crypto.Digest;
import org.encryfoundation.common.Algos$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final int byteSize;

    static {
        new Utils$();
    }

    public byte[] leIntToByteArray(int i) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(i);
        return buffer.array();
    }

    public byte[] nonceToLeBytes(BigInt nonce) {
        return (byte[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).map((Function1 & Serializable & scala.Serializable)i -> Utils$.MODULE$.leIntToByteArray(nonce.$greater$greater(32 * BoxesRunTime.unboxToInt((Object)i)).intValue()), IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
    }

    public <T extends Digest> T hashNonce(T digest, BigInt nonce) {
        byte[] arr = this.nonceToLeBytes(nonce);
        digest.update(arr, 0, arr.length);
        return digest;
    }

    private int byteSize() {
        return this.byteSize;
    }

    public byte countLeadingZeroes(byte[] bytes) {
        byte by;
        Object object = new Object();
        try {
            by = BoxesRunTime.unboxToByte((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.byteSize() * bytes.length).foldLeft((Object)BoxesRunTime.boxToByte((byte)((byte)0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToByte((byte)Utils$.$anonfun$countLeadingZeroes$1(bytes, object, BoxesRunTime.unboxToByte((Object)x0$1), BoxesRunTime.unboxToInt((Object)x1$1)))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                by = ex.value$mcB$sp();
            }
            throw ex;
        }
        return by;
    }

    public boolean validateSolution(byte[] solution, double target) {
        return (double)this.countLeadingZeroes(solution) >= target;
    }

    public long nonceFromDigest(byte[] digest) {
        return Longs.fromByteArray((byte[])((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Algos$.MODULE$.hash().apply(digest))).take(8)));
    }

    public static final /* synthetic */ byte $anonfun$countLeadingZeroes$1(byte[] bytes$1, Object nonLocalReturnKey1$1, byte x0$1, int x1$1) {
        byte res;
        block5: {
            Tuple2 tuple2;
            block4: {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)x0$1), (Object)BoxesRunTime.boxToInteger((int)x1$1));
                if (tuple2 == null) break block4;
                res = BoxesRunTime.unboxToByte((Object)tuple2._1());
                int i = tuple2._2$mcI$sp();
                if ((bytes$1[i / MODULE$.byteSize()] << i % MODULE$.byteSize() & 0x80) == 0) break block5;
            }
            if (tuple2 != null) {
                byte res2 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                throw new NonLocalReturnControl.mcB.sp(nonLocalReturnKey1$1, res2);
            }
            throw new MatchError((Object)tuple2);
        }
        byte by = (byte)(res + 1);
        return by;
    }

    private Utils$() {
        MODULE$ = this;
        this.byteSize = 8;
    }
}

