/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.kafka;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.enodeframework.kafka.KafkaTool;
import org.enodeframework.kafka.SendMessageService;
import org.enodeframework.messaging.IApplicationMessage;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.applicationmessage.AbstractApplicationMessagePublisher;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaApplicationMessagePublisher
extends AbstractApplicationMessagePublisher {
    private KafkaTemplate<String, String> producer;

    public KafkaTemplate<String, String> getProducer() {
        return this.producer;
    }

    public void setProducer(KafkaTemplate<String, String> producer) {
        this.producer = producer;
    }

    public CompletableFuture<Void> publishAsync(IApplicationMessage message) {
        return SendMessageService.sendMessageAsync(this.producer, this.buildKafkaMessage(message));
    }

    protected ProducerRecord<String, String> buildKafkaMessage(IApplicationMessage message) {
        QueueMessage queueMessage = this.createApplicationMessage(message);
        return KafkaTool.covertToProducerRecord(queueMessage);
    }
}

