/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.enodeframework.kafka.KafkaTool;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.domainevent.AbstractDomainEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.support.Acknowledgment;

public class KafkaDomainEventListener
extends AbstractDomainEventListener
implements AcknowledgingMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(KafkaDomainEventListener.class);

    public void onMessage(ConsumerRecord data, Acknowledgment acknowledgment) {
        QueueMessage queueMessage = KafkaTool.covertToQueueMessage(data);
        this.handle(queueMessage, context -> {
            if (acknowledgment != null) {
                acknowledgment.acknowledge();
            }
        });
    }

    public void onMessage(Object data) {
        logger.info("receive data:{}", data);
    }
}

