/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.kafka;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.enodeframework.eventing.DomainEventStreamMessage;
import org.enodeframework.kafka.KafkaTool;
import org.enodeframework.kafka.SendMessageService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.domainevent.AbstractDomainEventPublisher;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaDomainEventPublisher
extends AbstractDomainEventPublisher {
    private KafkaTemplate<String, String> producer;

    public KafkaTemplate<String, String> getProducer() {
        return this.producer;
    }

    public void setProducer(KafkaTemplate<String, String> producer) {
        this.producer = producer;
    }

    public CompletableFuture<Void> publishAsync(DomainEventStreamMessage eventStream) {
        return SendMessageService.sendMessageAsync(this.producer, this.buildKafkaMessage(eventStream));
    }

    protected ProducerRecord<String, String> buildKafkaMessage(DomainEventStreamMessage eventStream) {
        QueueMessage queueMessage = this.createDomainEventStreamMessage(eventStream);
        return KafkaTool.covertToProducerRecord(queueMessage);
    }
}

