/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.kafka;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.enodeframework.domain.IDomainException;
import org.enodeframework.kafka.KafkaTool;
import org.enodeframework.kafka.SendMessageService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.publishableexceptions.AbstractPublishableExceptionPublisher;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaPublishableExceptionPublisher
extends AbstractPublishableExceptionPublisher {
    private KafkaTemplate<String, String> producer;

    public KafkaTemplate<String, String> getProducer() {
        return this.producer;
    }

    public void setProducer(KafkaTemplate<String, String> producer) {
        this.producer = producer;
    }

    public CompletableFuture<Void> publishAsync(IDomainException exception) {
        return SendMessageService.sendMessageAsync(this.producer, this.buildKafkaMessage(exception));
    }

    protected ProducerRecord<String, String> buildKafkaMessage(IDomainException exception) {
        QueueMessage queueMessage = this.createExceptionMessage(exception);
        return KafkaTool.covertToProducerRecord(queueMessage);
    }
}

