/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.enodeframework.common.utilities.BitConverter;
import org.enodeframework.queue.QueueMessage;

public class KafkaTool {
    private static final String HEADER_CODE = "CODE";

    public static QueueMessage covertToQueueMessage(ConsumerRecord record) {
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setBody(String.valueOf(record.value()));
        queueMessage.setKey(String.valueOf(record.key()));
        queueMessage.setTopic(record.topic());
        return queueMessage;
    }

    public static ProducerRecord<String, String> covertToProducerRecord(QueueMessage queueMessage) {
        RecordHeaders headers = new RecordHeaders();
        RecordHeader header = new RecordHeader(HEADER_CODE, BitConverter.getBytes((int)queueMessage.getCode()));
        headers.add((Header)header);
        return new ProducerRecord(queueMessage.getTopic(), null, (Object)queueMessage.getRouteKey(), (Object)queueMessage.getBody(), (Iterable)headers);
    }
}

