/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.kafka;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.enodeframework.common.exception.IORuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class SendMessageService {
    private static final Logger logger = LoggerFactory.getLogger(SendMessageService.class);

    public static CompletableFuture<Void> sendMessageAsync(KafkaTemplate<String, String> producer, final ProducerRecord<String, String> message) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        producer.send(message).addCallback((ListenableFutureCallback)new ListenableFutureCallback<SendResult<String, String>>(){

            public void onFailure(Throwable throwable) {
                logger.error("ENode message async send has exception, message: {}", (Object)message, (Object)throwable);
                future.completeExceptionally((Throwable)new IORuntimeException(throwable));
            }

            public void onSuccess(SendResult<String, String> result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ENode message async send success, sendResult: {}, message: {}", result, (Object)message);
                }
                future.complete(null);
            }
        });
        return future;
    }
}

