/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.pg;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.enodeframework.common.EventStoreConfiguration;
import org.enodeframework.common.exception.EventStoreException;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.common.function.Action1;
import org.enodeframework.common.function.Func;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.eventing.AggregateEventAppendResult;
import org.enodeframework.eventing.BatchAggregateEventAppendResult;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventAppendResult;
import org.enodeframework.eventing.EventAppendStatus;
import org.enodeframework.eventing.IEventSerializer;
import org.enodeframework.eventing.IEventStore;
import org.enodeframework.pg.PgEventStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ,2\u00020\u0001:\u0001,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0019H\u0016J \u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0016J \u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0002J \u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\fH\u0002J4\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0019H\u0002J4\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/enodeframework/pg/PgEventStore;", "Lorg/enodeframework/eventing/IEventStore;", "client", "Lio/vertx/pgclient/PgPool;", "configuration", "Lorg/enodeframework/common/EventStoreConfiguration;", "eventSerializer", "Lorg/enodeframework/eventing/IEventSerializer;", "serializeService", "Lorg/enodeframework/common/serializing/ISerializeService;", "(Lio/vertx/pgclient/PgPool;Lorg/enodeframework/common/EventStoreConfiguration;Lorg/enodeframework/eventing/IEventSerializer;Lorg/enodeframework/common/serializing/ISerializeService;)V", "code", "", "batchAppendAggregateEvents", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/eventing/AggregateEventAppendResult;", "aggregateRootId", "eventStreamList", "", "Lorg/enodeframework/eventing/DomainEventStream;", "batchAppendAggregateEventsAsync", "", "batchAggregateEventAppendResult", "Lorg/enodeframework/eventing/BatchAggregateEventAppendResult;", "retryTimes", "", "batchAppendAsync", "Lorg/enodeframework/eventing/EventAppendResult;", "eventStreams", "convertFrom", "record", "Lio/vertx/core/json/JsonObject;", "findAsync", "version", "commandId", "findByCommandId", "findByVersion", "getDuplicatedId", "message", "queryAggregateEvents", "aggregateRootTypeName", "minVersion", "maxVersion", "queryAggregateEventsAsync", "Companion", "enode-pg"})
public final class PgEventStore
implements IEventStore {
    private final IEventSerializer eventSerializer;
    private final ISerializeService serializeService;
    private final EventStoreConfiguration configuration;
    private final PgPool client;
    private final String code;
    private static final Logger logger;
    private static final String INSERT_EVENT_SQL = "INSERT INTO %s (aggregate_root_id, aggregate_root_type_name, command_id, version, gmt_create, events) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String SELECT_MANY_BY_VERSION_SQL = "SELECT * FROM %s WHERE aggregate_root_id = ? AND version >= ? AND Version <= ? ORDER BY version";
    private static final String SELECT_ONE_BY_VERSION_SQL = "SELECT * FROM %s WHERE aggregate_root_id = ? AND version = ?";
    private static final String SELECT_ONE_BY_COMMAND_ID_SQL = "SELECT * FROM %s WHERE aggregate_root_id = ? AND command_id = ?";
    private static final Pattern PATTERN_POSTGRESQL;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<EventAppendResult> batchAppendAsync(@NotNull List<? extends DomainEventStream> eventStreams) {
        Intrinsics.checkNotNullParameter(eventStreams, (String)"eventStreams");
        CompletableFuture<EventAppendResult> future = new CompletableFuture<EventAppendResult>();
        EventAppendResult appendResult = new EventAppendResult();
        if (eventStreams.isEmpty()) {
            future.complete(appendResult);
            return future;
        }
        Map eventStreamMap2 = eventStreams.stream().distinct().collect(Collectors.groupingBy(batchAppendAsync.eventStreamMap.1.INSTANCE));
        BatchAggregateEventAppendResult batchAggregateEventAppendResult = new BatchAggregateEventAppendResult(eventStreamMap2.keySet().size());
        Map map = eventStreamMap2;
        Intrinsics.checkNotNullExpressionValue(map, (String)"eventStreamMap");
        Object object = map;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List value = entry2.getValue();
            void v1 = key;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
            List list = value;
            Intrinsics.checkNotNullExpressionValue(list, (String)"value");
            this.batchAppendAggregateEventsAsync((String)v1, list, batchAggregateEventAppendResult, 0);
        }
        CompletableFuture completableFuture = batchAggregateEventAppendResult.taskCompletionSource;
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"batchAggregateEventAppen\u2026sult.taskCompletionSource");
        return completableFuture;
    }

    private final void batchAppendAggregateEventsAsync(String aggregateRootId, List<? extends DomainEventStream> eventStreamList, BatchAggregateEventAppendResult batchAggregateEventAppendResult, int retryTimes) {
        IOHelper.tryAsyncActionRecursively((String)"BatchAppendAggregateEventsAsync", (Func)((Func)new Func<CompletableFuture<AggregateEventAppendResult>>(this, aggregateRootId, eventStreamList){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ List $eventStreamList;

            public final CompletableFuture<AggregateEventAppendResult> apply() {
                return PgEventStore.access$batchAppendAggregateEvents(this.this$0, this.$aggregateRootId, this.$eventStreamList);
            }
            {
                this.this$0 = pgEventStore;
                this.$aggregateRootId = string;
                this.$eventStreamList = list;
            }
        }), (Action1)((Action1)new Action1<AggregateEventAppendResult>(batchAggregateEventAppendResult, aggregateRootId){
            final /* synthetic */ BatchAggregateEventAppendResult $batchAggregateEventAppendResult;
            final /* synthetic */ String $aggregateRootId;

            public final void apply(@NotNull AggregateEventAppendResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                this.$batchAggregateEventAppendResult.addCompleteAggregate(this.$aggregateRootId, result);
            }
            {
                this.$batchAggregateEventAppendResult = batchAggregateEventAppendResult;
                this.$aggregateRootId = string;
            }
        }), (Func)((Func)new Func<String>(aggregateRootId, eventStreamList){
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ List $eventStreamList;

            @Nullable
            public final String apply() {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "[aggregateRootId: %s, eventStreamCount: %s]";
                Object[] objectArray = new Object[]{this.$aggregateRootId, this.$eventStreamList.size()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                return string2;
            }
            {
                this.$aggregateRootId = string;
                this.$eventStreamList = list;
            }
        }), null, (int)retryTimes, (boolean)true);
    }

    private final CompletableFuture<AggregateEventAppendResult> batchAppendAggregateEvents(String aggregateRootId, List<? extends DomainEventStream> eventStreamList) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = INSERT_EVENT_SQL;
        Object[] objectArray = new Object[]{this.configuration};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String sql = string2;
        CompletableFuture<AggregateEventAppendResult> future = new CompletableFuture<AggregateEventAppendResult>();
        List batch = new ArrayList();
        for (DomainEventStream domainEventStream : eventStreamList) {
            Tuple tuple = Tuple.of((Object)domainEventStream.getAggregateRootId(), (Object)domainEventStream.getAggregateRootTypeName(), (Object)domainEventStream.getCommandId(), (Object)domainEventStream.getVersion(), (Object)domainEventStream.getTimestamp().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), (Object)this.serializeService.serialize((Object)this.eventSerializer.serialize(domainEventStream.events())));
            Intrinsics.checkNotNullExpressionValue((Object)tuple, (String)"Tuple.of(\n              \u2026nts()))\n                )");
            batch.add(tuple);
        }
        this.client.withTransaction((Function)new Function<SqlConnection, Future<RowSet<Row>>>(sql, batch){
            final /* synthetic */ String $sql;
            final /* synthetic */ List $batch;

            public final Future<RowSet<Row>> apply(SqlConnection client) {
                return client.preparedQuery(this.$sql).executeBatch(this.$batch);
            }
            {
                this.$sql = string;
                this.$batch = list;
            }
        }).onComplete((Handler)new Handler<AsyncResult<RowSet<Row>>>(this, future){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ CompletableFuture $future;

            public final void handle(AsyncResult<RowSet<Row>> ar) {
                if (ar.succeeded()) {
                    AggregateEventAppendResult appendResult = new AggregateEventAppendResult();
                    appendResult.setEventAppendStatus(EventAppendStatus.Success);
                    this.$future.complete(appendResult);
                    return;
                }
                Throwable throwable = ar.cause();
                if (throwable instanceof PgException) {
                    if (Intrinsics.areEqual((Object)PgEventStore.access$getCode$p(this.this$0), (Object)((PgException)throwable).getCode())) {
                        String string = throwable.getMessage();
                        if (string != null) {
                            CharSequence charSequence = string;
                            String string2 = PgEventStore.access$getConfiguration$p(this.this$0).getEventVersionUkName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configuration.eventVersionUkName");
                            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) {
                                AggregateEventAppendResult appendResult = new AggregateEventAppendResult();
                                appendResult.setEventAppendStatus(EventAppendStatus.DuplicateEvent);
                                this.$future.complete(appendResult);
                                return;
                            }
                        }
                    }
                    if (Intrinsics.areEqual((Object)PgEventStore.access$getCode$p(this.this$0), (Object)((PgException)throwable).getCode())) {
                        String string = throwable.getMessage();
                        if (string != null) {
                            CharSequence charSequence = string;
                            String string3 = PgEventStore.access$getConfiguration$p(this.this$0).getEventCommandIdUkName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"configuration.eventCommandIdUkName");
                            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) {
                                AggregateEventAppendResult appendResult = new AggregateEventAppendResult();
                                appendResult.setEventAppendStatus(EventAppendStatus.DuplicateCommand);
                                String string4 = throwable.getMessage();
                                if (string4 == null) {
                                    string4 = "";
                                }
                                String commandId = PgEventStore.access$getDuplicatedId(this.this$0, string4);
                                if (!Strings.isNullOrEmpty((String)commandId)) {
                                    appendResult.setDuplicateCommandIds((List)Lists.newArrayList((Object[])new String[]{commandId}));
                                }
                                this.$future.complete(appendResult);
                                return;
                            }
                        }
                    }
                    PgEventStore.access$getLogger$cp().error("Batch append event has sql exception.", throwable);
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(throwable));
                    return;
                }
                PgEventStore.access$getLogger$cp().error("Batch append event has unknown exception.", throwable);
                this.$future.completeExceptionally((Throwable)new EventStoreException(throwable));
            }
            {
                this.this$0 = pgEventStore;
                this.$future = completableFuture;
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<List<DomainEventStream>> queryAggregateEventsAsync(@NotNull String aggregateRootId, @NotNull String aggregateRootTypeName, int minVersion, int maxVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        return IOHelper.tryIOFuncAsync((Func)((Func)new Func<CompletableFuture<List<? extends DomainEventStream>>>(this, aggregateRootId, aggregateRootTypeName, minVersion, maxVersion){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ String $aggregateRootTypeName;
            final /* synthetic */ int $minVersion;
            final /* synthetic */ int $maxVersion;

            public final CompletableFuture<List<DomainEventStream>> apply() {
                return PgEventStore.access$queryAggregateEvents(this.this$0, this.$aggregateRootId, this.$aggregateRootTypeName, this.$minVersion, this.$maxVersion);
            }
            {
                this.this$0 = pgEventStore;
                this.$aggregateRootId = string;
                this.$aggregateRootTypeName = string2;
                this.$minVersion = n;
                this.$maxVersion = n2;
            }
        }), (String)"QueryAggregateEventsAsync");
    }

    private final CompletableFuture<List<DomainEventStream>> queryAggregateEvents(String aggregateRootId, String aggregateRootTypeName, int minVersion, int maxVersion) {
        CompletableFuture<List<DomainEventStream>> future = new CompletableFuture<List<DomainEventStream>>();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = SELECT_MANY_BY_VERSION_SQL;
        Object[] objectArray = new Object[]{this.configuration.getEventTableName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String sql = string2;
        Future resultSet = this.client.preparedQuery(sql).execute(Tuple.of((Object)aggregateRootId, (Object)minVersion, (Object)maxVersion));
        resultSet.onComplete((Handler)new Handler<AsyncResult<RowSet<Row>>>(this, future, aggregateRootId, aggregateRootTypeName){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ String $aggregateRootTypeName;

            /*
             * WARNING - void declaration
             */
            public final void handle(AsyncResult<RowSet<Row>> ar) {
                if (ar.succeeded()) {
                    Collection<DomainEventStream> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object object = ar.result();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ar.result()");
                    Iterable iterable = (Iterable)object;
                    CompletableFuture completableFuture = this.$future;
                    boolean $i$f$map = false;
                    void var4_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void row;
                        Row row2 = (Row)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        JsonObject jsonObject = row.toJson();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"row.toJson()");
                        DomainEventStream domainEventStream = PgEventStore.access$convertFrom(this.this$0, jsonObject);
                        collection.add(domainEventStream);
                    }
                    collection = (List)destination$iv$iv;
                    completableFuture.complete(CollectionsKt.toMutableList((Collection)collection));
                    return;
                }
                Throwable throwable = ar.cause();
                if (throwable instanceof PgException) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "Failed to query aggregate events async, aggregateRootId: %s, aggregateRootType: %s";
                    Object[] objectArray = new Object[]{this.$aggregateRootId, this.$aggregateRootTypeName};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    String errorMessage = string2;
                    PgEventStore.access$getLogger$cp().error(errorMessage, throwable);
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(throwable));
                    return;
                }
                PgEventStore.access$getLogger$cp().error("Failed to query aggregate events async, aggregateRootId: {}, aggregateRootType: {}", new Object[]{this.$aggregateRootId, this.$aggregateRootTypeName, throwable});
                this.$future.completeExceptionally((Throwable)new EventStoreException(throwable));
            }
            {
                this.this$0 = pgEventStore;
                this.$future = completableFuture;
                this.$aggregateRootId = string;
                this.$aggregateRootTypeName = string2;
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<DomainEventStream> findAsync(@NotNull String aggregateRootId, int version) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return IOHelper.tryIOFuncAsync((Func)((Func)new Func<CompletableFuture<DomainEventStream>>(this, aggregateRootId, version){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ int $version;

            public final CompletableFuture<DomainEventStream> apply() {
                return PgEventStore.access$findByVersion(this.this$0, this.$aggregateRootId, this.$version);
            }
            {
                this.this$0 = pgEventStore;
                this.$aggregateRootId = string;
                this.$version = n;
            }
        }), (String)"FindEventByVersionAsync");
    }

    private final CompletableFuture<DomainEventStream> findByVersion(String aggregateRootId, int version) {
        CompletableFuture<DomainEventStream> future = new CompletableFuture<DomainEventStream>();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = SELECT_ONE_BY_VERSION_SQL;
        Object[] objectArray = new Object[]{this.configuration.getEventTableName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String sql = string2;
        JsonArray array = new JsonArray();
        array.add((Object)aggregateRootId);
        array.add((Object)version);
        Future rowSet = this.client.preparedQuery(sql).execute(Tuple.of((Object)aggregateRootId, (Object)version));
        rowSet.onComplete((Handler)new Handler<AsyncResult<RowSet<Row>>>(this, future, aggregateRootId, version){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ int $version;

            /*
             * WARNING - void declaration
             */
            public final void handle(AsyncResult<RowSet<Row>> ar) {
                if (ar.succeeded()) {
                    DomainEventStream domainEventStream;
                    Object object = ar.result();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ar.result()");
                    Object object2 = CollectionsKt.firstOrNull((Iterable)((Iterable)object));
                    boolean bl = false;
                    boolean bl2 = false;
                    Row row = (Row)object2;
                    boolean bl3 = false;
                    CompletableFuture completableFuture = this.$future;
                    Row row2 = row;
                    if (row2 != null) {
                        void it;
                        Row row3 = row2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Row row4 = row3;
                        CompletableFuture completableFuture2 = completableFuture;
                        boolean bl6 = false;
                        JsonObject jsonObject = it.toJson();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"it.toJson()");
                        DomainEventStream domainEventStream2 = PgEventStore.access$convertFrom(this.this$0, jsonObject);
                        completableFuture = completableFuture2;
                        domainEventStream = domainEventStream2;
                    } else {
                        domainEventStream = null;
                    }
                    completableFuture.complete(domainEventStream);
                    return;
                }
                Throwable throwable = ar.cause();
                if (throwable instanceof PgException) {
                    PgEventStore.access$getLogger$cp().error("Find event by version has sql exception, aggregateRootId: {}, version: {}", new Object[]{this.$aggregateRootId, this.$version, throwable});
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(throwable));
                    return;
                }
                PgEventStore.access$getLogger$cp().error("Find event by version has unknown exception, aggregateRootId: {}, version: {}", new Object[]{this.$aggregateRootId, this.$version, throwable});
                this.$future.completeExceptionally((Throwable)new EventStoreException(throwable));
            }
            {
                this.this$0 = pgEventStore;
                this.$future = completableFuture;
                this.$aggregateRootId = string;
                this.$version = n;
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<DomainEventStream> findAsync(@NotNull String aggregateRootId, @NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        return IOHelper.tryIOFuncAsync((Func)((Func)new Func<CompletableFuture<DomainEventStream>>(this, aggregateRootId, commandId){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ String $commandId;

            public final CompletableFuture<DomainEventStream> apply() {
                return PgEventStore.access$findByCommandId(this.this$0, this.$aggregateRootId, this.$commandId);
            }
            {
                this.this$0 = pgEventStore;
                this.$aggregateRootId = string;
                this.$commandId = string2;
            }
        }), (String)"FindEventByCommandIdAsync");
    }

    private final CompletableFuture<DomainEventStream> findByCommandId(String aggregateRootId, String commandId) {
        CompletableFuture<DomainEventStream> future = new CompletableFuture<DomainEventStream>();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = SELECT_ONE_BY_COMMAND_ID_SQL;
        Object[] objectArray = new Object[]{this.configuration.getEventTableName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String sql = string2;
        this.client.preparedQuery(sql).execute(Tuple.of((Object)aggregateRootId, (Object)commandId)).onComplete((Handler)new Handler<AsyncResult<RowSet<Row>>>(this, future, aggregateRootId, commandId){
            final /* synthetic */ PgEventStore this$0;
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ String $commandId;

            /*
             * WARNING - void declaration
             */
            public final void handle(AsyncResult<RowSet<Row>> ar) {
                if (ar.succeeded()) {
                    DomainEventStream domainEventStream;
                    Object object = ar.result();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ar.result()");
                    Object object2 = CollectionsKt.firstOrNull((Iterable)((Iterable)object));
                    boolean bl = false;
                    boolean bl2 = false;
                    Row row = (Row)object2;
                    boolean bl3 = false;
                    CompletableFuture completableFuture = this.$future;
                    Row row2 = row;
                    if (row2 != null) {
                        void it;
                        Row row3 = row2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Row row4 = row3;
                        CompletableFuture completableFuture2 = completableFuture;
                        boolean bl6 = false;
                        JsonObject jsonObject = it.toJson();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"it.toJson()");
                        DomainEventStream domainEventStream2 = PgEventStore.access$convertFrom(this.this$0, jsonObject);
                        completableFuture = completableFuture2;
                        domainEventStream = domainEventStream2;
                    } else {
                        domainEventStream = null;
                    }
                    completableFuture.complete(domainEventStream);
                    return;
                }
                Throwable throwable = ar.cause();
                if (throwable instanceof PgException) {
                    PgEventStore.access$getLogger$cp().error("Find event by commandId has sql exception, aggregateRootId: {}, commandId: {}", new Object[]{this.$aggregateRootId, this.$commandId, throwable});
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(throwable));
                    return;
                }
                PgEventStore.access$getLogger$cp().error("Find event by commandId has unknown exception, aggregateRootId: {}, commandId: {}", new Object[]{this.$aggregateRootId, this.$commandId, throwable});
                this.$future.completeExceptionally((Throwable)new EventStoreException(throwable));
            }
            {
                this.this$0 = pgEventStore;
                this.$future = completableFuture;
                this.$aggregateRootId = string;
                this.$commandId = string2;
            }
        });
        return future;
    }

    private final DomainEventStream convertFrom(JsonObject record) {
        Object object = this.serializeService.deserialize(record.getString("events"), Map.class);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        }
        return new DomainEventStream(record.getString("command_id"), record.getString("aggregate_root_id"), record.getString("aggregate_root_type_name"), Date.from(LocalDateTime.parse(record.getString("gmt_create")).atZone(ZoneId.systemDefault()).toInstant()), this.eventSerializer.deserialize(TypeIntrinsics.asMutableMap((Object)object)), (Map)Maps.newHashMap());
    }

    private final String getDuplicatedId(String message) {
        String string;
        Matcher matcher = PATTERN_POSTGRESQL.matcher(message);
        if (!matcher.find()) {
            return "";
        }
        if (matcher.groupCount() == 0) {
            string = "";
        } else {
            String string2 = matcher.group(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(1)");
        }
        return string;
    }

    public PgEventStore(@NotNull PgPool client, @NotNull EventStoreConfiguration configuration, @NotNull IEventSerializer eventSerializer, @NotNull ISerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)eventSerializer, (String)"eventSerializer");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.code = "23505";
        this.client = client;
        this.eventSerializer = eventSerializer;
        this.serializeService = serializeService;
        this.configuration = configuration;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(PgEventStore.class);
        PATTERN_POSTGRESQL = Pattern.compile("=\\(.*, (.*)\\) already exists.$");
    }

    public static final /* synthetic */ CompletableFuture access$batchAppendAggregateEvents(PgEventStore $this, String aggregateRootId, List eventStreamList) {
        return $this.batchAppendAggregateEvents(aggregateRootId, eventStreamList);
    }

    public static final /* synthetic */ String access$getCode$p(PgEventStore $this) {
        return $this.code;
    }

    public static final /* synthetic */ EventStoreConfiguration access$getConfiguration$p(PgEventStore $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ String access$getDuplicatedId(PgEventStore $this, String message) {
        return $this.getDuplicatedId(message);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ CompletableFuture access$queryAggregateEvents(PgEventStore $this, String aggregateRootId, String aggregateRootTypeName, int minVersion, int maxVersion) {
        return $this.queryAggregateEvents(aggregateRootId, aggregateRootTypeName, minVersion, maxVersion);
    }

    public static final /* synthetic */ DomainEventStream access$convertFrom(PgEventStore $this, JsonObject record) {
        return $this.convertFrom(record);
    }

    public static final /* synthetic */ CompletableFuture access$findByVersion(PgEventStore $this, String aggregateRootId, int version) {
        return $this.findByVersion(aggregateRootId, version);
    }

    public static final /* synthetic */ CompletableFuture access$findByCommandId(PgEventStore $this, String aggregateRootId, String commandId) {
        return $this.findByCommandId(aggregateRootId, commandId);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/enodeframework/pg/PgEventStore$Companion;", "", "()V", "INSERT_EVENT_SQL", "", "PATTERN_POSTGRESQL", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SELECT_MANY_BY_VERSION_SQL", "SELECT_ONE_BY_COMMAND_ID_SQL", "SELECT_ONE_BY_VERSION_SQL", "logger", "Lorg/slf4j/Logger;", "enode-pg"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

