/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.pg;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.enodeframework.common.EventStoreConfiguration;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.common.exception.PublishedVersionStoreException;
import org.enodeframework.common.function.Func;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.eventing.IPublishedVersionStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/enodeframework/pg/PgPublishedVersionStore;", "Lorg/enodeframework/eventing/IPublishedVersionStore;", "client", "Lio/vertx/pgclient/PgPool;", "configuration", "Lorg/enodeframework/common/EventStoreConfiguration;", "(Lio/vertx/pgclient/PgPool;Lorg/enodeframework/common/EventStoreConfiguration;)V", "code", "", "getPublishedVersion", "Ljava/util/concurrent/CompletableFuture;", "", "processorName", "aggregateRootTypeName", "aggregateRootId", "getPublishedVersionAsync", "insertVersionAsync", "publishedVersion", "updatePublishedVersion", "updatePublishedVersionAsync", "updateVersionAsync", "Companion", "enode-pg"})
public final class PgPublishedVersionStore
implements IPublishedVersionStore {
    private final String code;
    private final PgPool client;
    private final EventStoreConfiguration configuration;
    private static final Logger logger;
    private static final String INSERT_SQL = "INSERT INTO %s (processor_name, aggregate_root_type_name, aggregate_root_id, version, gmt_create) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL = "UPDATE %s SET version = ?, gmt_create = ? WHERE processor_name = ? AND aggregate_root_id = ? AND version = ?";
    private static final String SELECT_SQL = "SELECT version FROM %s WHERE processor_name = ? AND aggregate_root_id = ?";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public CompletableFuture<Integer> updatePublishedVersionAsync(@NotNull String processorName, @NotNull String aggregateRootTypeName, @NotNull String aggregateRootId, int publishedVersion) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return IOHelper.tryIOFuncAsync((Func)((Func)new Func<CompletableFuture<Integer>>(this, processorName, aggregateRootTypeName, aggregateRootId, publishedVersion){
            final /* synthetic */ PgPublishedVersionStore this$0;
            final /* synthetic */ String $processorName;
            final /* synthetic */ String $aggregateRootTypeName;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ int $publishedVersion;

            public final CompletableFuture<Integer> apply() {
                return PgPublishedVersionStore.access$updatePublishedVersion(this.this$0, this.$processorName, this.$aggregateRootTypeName, this.$aggregateRootId, this.$publishedVersion);
            }
            {
                this.this$0 = pgPublishedVersionStore;
                this.$processorName = string;
                this.$aggregateRootTypeName = string2;
                this.$aggregateRootId = string3;
                this.$publishedVersion = n;
            }
        }), (String)"UpdatePublishedVersionAsync");
    }

    private final CompletableFuture<Integer> updatePublishedVersion(String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        boolean insert;
        boolean bl = insert = publishedVersion == 1;
        if (insert) {
            return this.insertVersionAsync(processorName, aggregateRootTypeName, aggregateRootId, publishedVersion);
        }
        return this.updateVersionAsync(processorName, aggregateRootTypeName, aggregateRootId, publishedVersion);
    }

    private final CompletableFuture<Integer> updateVersionAsync(String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = UPDATE_SQL;
        Object[] objectArray = new Object[]{this.configuration.getPublishedTableName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String sql = string2;
        Tuple tuple = Tuple.of((Object)publishedVersion, (Object)LocalDateTime.now(), (Object)processorName, (Object)aggregateRootId, (Object)(publishedVersion - 1));
        this.client.preparedQuery(sql).execute(tuple).onComplete((Handler)new Handler<AsyncResult<RowSet<Row>>>(future, tuple){
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ Tuple $tuple;

            public final void handle(AsyncResult<RowSet<Row>> ar) {
                if (ar.succeeded()) {
                    this.$future.complete(((RowSet)ar.result()).rowCount());
                    if (((RowSet)ar.result()).rowCount() == 0) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "version update rows is 0. %s";
                        Object[] objectArray = new Object[]{this.$tuple};
                        boolean bl = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        this.$future.completeExceptionally((Throwable)new PublishedVersionStoreException(string2));
                    }
                    return;
                }
                Throwable throwable = ar.cause();
                if (throwable instanceof PgException) {
                    PgPublishedVersionStore.access$getLogger$cp().error("Update aggregate published version has sql exception. {}", (Object)this.$tuple, (Object)throwable);
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(throwable));
                    return;
                }
                PgPublishedVersionStore.access$getLogger$cp().error("Update aggregate published version has unknown exception. {}", (Object)this.$tuple, (Object)throwable);
                this.$future.completeExceptionally((Throwable)new PublishedVersionStoreException(throwable));
            }
            {
                this.$future = completableFuture;
                this.$tuple = tuple;
            }
        });
        return future;
    }

    private final CompletableFuture<Integer> insertVersionAsync(String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = INSERT_SQL;
        Object[] objectArray = new Object[]{this.configuration.getPublishedTableName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String sql = string2;
        Tuple tuple = Tuple.of((Object)processorName, (Object)aggregateRootTypeName, (Object)aggregateRootId, (Object)1, (Object)LocalDateTime.now());
        this.client.preparedQuery(sql).execute(tuple).onComplete((Handler)new Handler<AsyncResult<RowSet<Row>>>(this, future, tuple){
            final /* synthetic */ PgPublishedVersionStore this$0;
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ Tuple $tuple;

            public final void handle(AsyncResult<RowSet<Row>> ar) {
                if (ar.succeeded()) {
                    this.$future.complete(((RowSet)ar.result()).rowCount());
                    return;
                }
                Throwable throwable = ar.cause();
                if (throwable instanceof PgException) {
                    if (Intrinsics.areEqual((Object)PgPublishedVersionStore.access$getCode$p(this.this$0), (Object)((PgException)throwable).getCode())) {
                        String string = throwable.getMessage();
                        if (string != null) {
                            CharSequence charSequence = string;
                            String string2 = PgPublishedVersionStore.access$getConfiguration$p(this.this$0).getPublishedUkName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configuration.publishedUkName");
                            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) {
                                this.$future.complete(1);
                                return;
                            }
                        }
                    }
                    PgPublishedVersionStore.access$getLogger$cp().error("Insert aggregate published version has sql exception. {}", (Object)this.$tuple, (Object)throwable);
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(throwable));
                    return;
                }
                PgPublishedVersionStore.access$getLogger$cp().error("Insert aggregate published version has unknown exception. {}", (Object)this.$tuple, (Object)throwable);
                this.$future.completeExceptionally((Throwable)new PublishedVersionStoreException(throwable));
            }
            {
                this.this$0 = pgPublishedVersionStore;
                this.$future = completableFuture;
                this.$tuple = tuple;
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Integer> getPublishedVersionAsync(@NotNull String processorName, @NotNull String aggregateRootTypeName, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return IOHelper.tryIOFuncAsync((Func)((Func)new Func<CompletableFuture<Integer>>(this, processorName, aggregateRootTypeName, aggregateRootId){
            final /* synthetic */ PgPublishedVersionStore this$0;
            final /* synthetic */ String $processorName;
            final /* synthetic */ String $aggregateRootTypeName;
            final /* synthetic */ String $aggregateRootId;

            public final CompletableFuture<Integer> apply() {
                return PgPublishedVersionStore.access$getPublishedVersion(this.this$0, this.$processorName, this.$aggregateRootTypeName, this.$aggregateRootId);
            }
            {
                this.this$0 = pgPublishedVersionStore;
                this.$processorName = string;
                this.$aggregateRootTypeName = string2;
                this.$aggregateRootId = string3;
            }
        }), (String)"UpdatePublishedVersionAsync");
    }

    private final CompletableFuture<Integer> getPublishedVersion(String processorName, String aggregateRootTypeName, String aggregateRootId) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = SELECT_SQL;
        Object[] objectArray = new Object[]{this.configuration.getPublishedTableName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String sql = string2;
        this.client.preparedQuery(sql).execute(Tuple.of((Object)processorName, (Object)aggregateRootId)).onComplete((Handler)new Handler<AsyncResult<RowSet<Row>>>(future){
            final /* synthetic */ CompletableFuture $future;

            public final void handle(AsyncResult<RowSet<Row>> ar) {
                if (ar.succeeded()) {
                    Object object = ar.result();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ar.result()");
                    Object object2 = CollectionsKt.firstOrNull((Iterable)((Iterable)object));
                    boolean bl = false;
                    boolean bl2 = false;
                    Row row = (Row)object2;
                    boolean bl3 = false;
                    if (row == null) {
                        this.$future.complete(0);
                        return;
                    }
                    this.$future.complete(row.getInteger(0));
                    return;
                }
                Throwable throwable = ar.cause();
                if (throwable instanceof PgException) {
                    PgPublishedVersionStore.access$getLogger$cp().error("Get aggregate published version has sql exception.", throwable);
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(throwable));
                    return;
                }
                PgPublishedVersionStore.access$getLogger$cp().error("Get aggregate published version has unknown exception.", throwable);
                this.$future.completeExceptionally((Throwable)new PublishedVersionStoreException(throwable));
            }
            {
                this.$future = completableFuture;
            }
        });
        return future;
    }

    public PgPublishedVersionStore(@NotNull PgPool client, @NotNull EventStoreConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.client = client;
        this.configuration = configuration;
        this.code = "23505";
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(PgPublishedVersionStore.class);
    }

    public static final /* synthetic */ CompletableFuture access$updatePublishedVersion(PgPublishedVersionStore $this, String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        return $this.updatePublishedVersion(processorName, aggregateRootTypeName, aggregateRootId, publishedVersion);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$getCode$p(PgPublishedVersionStore $this) {
        return $this.code;
    }

    public static final /* synthetic */ EventStoreConfiguration access$getConfiguration$p(PgPublishedVersionStore $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ CompletableFuture access$getPublishedVersion(PgPublishedVersionStore $this, String processorName, String aggregateRootTypeName, String aggregateRootId) {
        return $this.getPublishedVersion(processorName, aggregateRootTypeName, aggregateRootId);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/enodeframework/pg/PgPublishedVersionStore$Companion;", "", "()V", "INSERT_SQL", "", "SELECT_SQL", "UPDATE_SQL", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode-pg"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

