/*
 * Decompiled with CFR 0.152.
 */
package org.enode.pulsar.message;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Producer;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.queue.ISendMessageService;
import org.enodeframework.queue.QueueMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSendMessageService
implements ISendMessageService {
    private static final Logger logger = LoggerFactory.getLogger(PulsarSendMessageService.class);
    private final Producer<QueueMessage> producer;

    public PulsarSendMessageService(Producer producer) {
        this.producer = producer;
    }

    public CompletableFuture<Boolean> sendMessageAsync(QueueMessage queueMessage) {
        return ((CompletableFuture)this.producer.sendAsync((Object)queueMessage).exceptionally(throwable -> {
            logger.error("Enode message async send has exception, message: {}, routingKey: {}", new Object[]{queueMessage.getBody(), queueMessage.getRouteKey(), throwable});
            throw new IORuntimeException(throwable);
        })).thenApply(x -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Enode message async send success, sendResult: {}, message: {}", (Object)x.toByteArray(), (Object)queueMessage.getBody());
            }
            return true;
        });
    }
}

